// GENERATED FILE - DO NOT EDIT.
// Generated by gen_texture_format_table.py using data from texture_format_data.json
//
// Copyright 2015 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// texture_format_table:
//   Queries for full textureFormat information based in internalFormat
//

#include "libANGLE/renderer/d3d/d3d11/texture_format_table.h"

#include "libANGLE/renderer/d3d/d3d11/formatutils11.h"
#include "libANGLE/renderer/d3d/d3d11/internal_format_initializer_table.h"
#include "libANGLE/renderer/d3d/d3d11/load_functions_table.h"
#include "libANGLE/renderer/d3d/d3d11/renderer11_utils.h"
#include "libANGLE/renderer/d3d/d3d11/swizzle_format_info.h"
#include "libANGLE/renderer/d3d/loadimage.h"

namespace rx
{

namespace d3d11
{

namespace
{

typedef bool (*FormatSupportFunction)(const Renderer11DeviceCaps &);

bool AnyDevice(const Renderer11DeviceCaps &deviceCaps)
{
    return true;
}

bool OnlyFL10Plus(const Renderer11DeviceCaps &deviceCaps)
{
    return (deviceCaps.featureLevel >= D3D_FEATURE_LEVEL_10_0);
}

bool OnlyFL9_3(const Renderer11DeviceCaps &deviceCaps)
{
    return (deviceCaps.featureLevel == D3D_FEATURE_LEVEL_9_3);
}

template <DXGI_FORMAT format, bool requireSupport>
bool SupportsFormat(const Renderer11DeviceCaps &deviceCaps)
{
    // Must support texture, SRV and RTV support
    UINT mustSupport = D3D11_FORMAT_SUPPORT_TEXTURE2D | D3D11_FORMAT_SUPPORT_TEXTURECUBE |
                       D3D11_FORMAT_SUPPORT_SHADER_SAMPLE | D3D11_FORMAT_SUPPORT_MIP |
                       D3D11_FORMAT_SUPPORT_RENDER_TARGET;

    if (d3d11_gl::GetMaximumClientVersion(deviceCaps.featureLevel) > 2)
    {
        mustSupport |= D3D11_FORMAT_SUPPORT_TEXTURE3D;
    }

    bool fullSupport = false;
    if (format == DXGI_FORMAT_B5G6R5_UNORM)
    {
        // All hardware that supports DXGI_FORMAT_B5G6R5_UNORM should support autogen mipmaps, but
        // check anyway.
        mustSupport |= D3D11_FORMAT_SUPPORT_MIP_AUTOGEN;
        fullSupport = ((deviceCaps.B5G6R5support & mustSupport) == mustSupport);
    }
    else if (format == DXGI_FORMAT_B4G4R4A4_UNORM)
    {
        fullSupport = ((deviceCaps.B4G4R4A4support & mustSupport) == mustSupport);
    }
    else if (format == DXGI_FORMAT_B5G5R5A1_UNORM)
    {
        fullSupport = ((deviceCaps.B5G5R5A1support & mustSupport) == mustSupport);
    }
    else
    {
        UNREACHABLE();
        return false;
    }

    // This 'SupportsFormat' function is used by individual entries in the D3D11 Format Map below,
    // which maps GL formats to DXGI formats.
    if (requireSupport)
    {
        // This means that ANGLE would like to use the entry in the map if the inputted DXGI format
        // *IS* supported.
        // e.g. the entry might map GL_RGB5_A1 to DXGI_FORMAT_B5G5R5A1, which should only be used if
        // DXGI_FORMAT_B5G5R5A1 is supported.
        // In this case, we should only return 'true' if the format *IS* supported.
        return fullSupport;
    }
    else
    {
        // This means that ANGLE would like to use the entry in the map if the inputted DXGI format
        // *ISN'T* supported.
        // This might be a fallback entry. e.g. for ANGLE to use DXGI_FORMAT_R8G8B8A8_UNORM if
        // DXGI_FORMAT_B5G5R5A1 isn't supported.
        // In this case, we should only return 'true' if the format *ISN'T* supported.
        return !fullSupport;
    }
}

// End Format Support Functions

// For sized GL internal formats, there are several possible corresponding D3D11 formats depending
// on device capabilities.
// This function allows querying for the DXGI texture formats to use for textures, SRVs, RTVs and
// DSVs given a GL internal format.
const TextureFormat GetD3D11FormatInfo(GLenum internalFormat,
                                       DXGI_FORMAT texFormat,
                                       DXGI_FORMAT srvFormat,
                                       DXGI_FORMAT rtvFormat,
                                       DXGI_FORMAT dsvFormat)
{
    TextureFormat info;
    info.texFormat = texFormat;
    info.srvFormat = srvFormat;
    info.rtvFormat = rtvFormat;
    info.dsvFormat = dsvFormat;

    // Given a GL internal format, the renderFormat is the DSV format if it is depth- or
    // stencil-renderable,
    // the RTV format if it is color-renderable, and the (nonrenderable) texture format otherwise.
    if (dsvFormat != DXGI_FORMAT_UNKNOWN)
    {
        info.renderFormat = dsvFormat;
    }
    else if (rtvFormat != DXGI_FORMAT_UNKNOWN)
    {
        info.renderFormat = rtvFormat;
    }
    else if (texFormat != DXGI_FORMAT_UNKNOWN)
    {
        info.renderFormat = texFormat;
    }
    else
    {
        info.renderFormat = DXGI_FORMAT_UNKNOWN;
    }

    // Compute the swizzle formats
    const gl::InternalFormat &formatInfo = gl::GetInternalFormatInfo(internalFormat);
    if (internalFormat != GL_NONE && formatInfo.pixelBytes > 0)
    {
        if (formatInfo.componentCount != 4 || texFormat == DXGI_FORMAT_UNKNOWN ||
            srvFormat == DXGI_FORMAT_UNKNOWN || rtvFormat == DXGI_FORMAT_UNKNOWN)
        {
            // Get the maximum sized component
            unsigned int maxBits = 1;
            if (formatInfo.compressed)
            {
                unsigned int compressedBitsPerBlock = formatInfo.pixelBytes * 8;
                unsigned int blockSize =
                    formatInfo.compressedBlockWidth * formatInfo.compressedBlockHeight;
                maxBits = std::max(compressedBitsPerBlock / blockSize, maxBits);
            }
            else
            {
                maxBits = std::max(maxBits, formatInfo.alphaBits);
                maxBits = std::max(maxBits, formatInfo.redBits);
                maxBits = std::max(maxBits, formatInfo.greenBits);
                maxBits = std::max(maxBits, formatInfo.blueBits);
                maxBits = std::max(maxBits, formatInfo.luminanceBits);
                maxBits = std::max(maxBits, formatInfo.depthBits);
            }

            maxBits = roundUp(maxBits, 8U);

            const SwizzleFormatInfo &swizzleInfo =
                GetSwizzleFormatInfo(maxBits, formatInfo.componentType);
            info.swizzleTexFormat = swizzleInfo.mTexFormat;
            info.swizzleSRVFormat = swizzleInfo.mSRVFormat;
            info.swizzleRTVFormat = swizzleInfo.mRTVFormat;
        }
        else
        {
            // The original texture format is suitable for swizzle operations
            info.swizzleTexFormat = texFormat;
            info.swizzleSRVFormat = srvFormat;
            info.swizzleRTVFormat = rtvFormat;
        }
    }
    else
    {
        // Not possible to swizzle with this texture format since it is either unsized or GL_NONE
        info.swizzleTexFormat = DXGI_FORMAT_UNKNOWN;
        info.swizzleSRVFormat = DXGI_FORMAT_UNKNOWN;
        info.swizzleRTVFormat = DXGI_FORMAT_UNKNOWN;
    }

    // Check if there is an initialization function for this texture format
    info.dataInitializerFunction = GetInternalFormatInitializer(internalFormat, texFormat);
    // Gather all the load functions for this internal format
    info.loadFunctions = GetLoadFunctionsMap(internalFormat, texFormat);

    ASSERT(info.loadFunctions.size() != 0 || internalFormat == GL_NONE);

    return info;
}

}  // namespace

TextureFormat::TextureFormat()
    : texFormat(DXGI_FORMAT_UNKNOWN),
      srvFormat(DXGI_FORMAT_UNKNOWN),
      rtvFormat(DXGI_FORMAT_UNKNOWN),
      dsvFormat(DXGI_FORMAT_UNKNOWN),
      renderFormat(DXGI_FORMAT_UNKNOWN),
      swizzleTexFormat(DXGI_FORMAT_UNKNOWN),
      swizzleSRVFormat(DXGI_FORMAT_UNKNOWN),
      swizzleRTVFormat(DXGI_FORMAT_UNKNOWN),
      dataInitializerFunction(NULL),
      loadFunctions()
{
}

const TextureFormat &GetTextureFormatInfo(GLenum internalFormat,
                                          const Renderer11DeviceCaps &renderer11DeviceCaps)
{
    // clang-format off
    switch (internalFormat)
    {
        case GL_ALPHA:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_A8_UNORM,
                                                                              DXGI_FORMAT_A8_UNORM,
                                                                              DXGI_FORMAT_A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_ALPHA16F_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_ALPHA32F_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_ALPHA8_EXT:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_A8_UNORM,
                                                                              DXGI_FORMAT_A8_UNORM,
                                                                              DXGI_FORMAT_A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_BGR5_A1_ANGLEX:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_BGRA4_ANGLEX:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_BGRA8_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_BGRA_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_B8G8R8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_R11_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8_UNORM,
                                                                              DXGI_FORMAT_R8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RG11_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8_UNORM,
                                                                              DXGI_FORMAT_R8G8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGB8_ETC2:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGBA8_ETC2_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT1_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_BC1_UNORM,
                                                                              DXGI_FORMAT_BC1_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_BC2_UNORM,
                                                                              DXGI_FORMAT_BC2_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_BC3_UNORM,
                                                                              DXGI_FORMAT_BC3_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_RGB_S3TC_DXT1_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_BC1_UNORM,
                                                                              DXGI_FORMAT_BC1_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SIGNED_R11_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8_SNORM,
                                                                              DXGI_FORMAT_R8_SNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SIGNED_RG11_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8_SNORM,
                                                                              DXGI_FORMAT_R8G8_SNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SRGB8_ETC2:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH24_STENCIL8:
        {
            if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT);
                return textureFormat;
            }
            else if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R24G8_TYPELESS,
                                                                              DXGI_FORMAT_R24_UNORM_X8_TYPELESS,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH32F_STENCIL8:
        {
            if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G8X24_TYPELESS,
                                                                              DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D32_FLOAT_S8X24_UINT);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH_COMPONENT16:
        {
            if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_D16_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D16_UNORM);
                return textureFormat;
            }
            else if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16_TYPELESS,
                                                                              DXGI_FORMAT_R16_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D16_UNORM);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH_COMPONENT24:
        {
            if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT);
                return textureFormat;
            }
            else if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R24G8_TYPELESS,
                                                                              DXGI_FORMAT_R24_UNORM_X8_TYPELESS,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH_COMPONENT32F:
        {
            if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32_TYPELESS,
                                                                              DXGI_FORMAT_R32_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D32_FLOAT);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_DEPTH_COMPONENT32_OES:
        {
            if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R24G8_TYPELESS,
                                                                              DXGI_FORMAT_R24_UNORM_X8_TYPELESS,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_ETC1_RGB8_LOSSY_DECODE_ANGLE:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_BC1_UNORM,
                                                                              DXGI_FORMAT_BC1_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_ETC1_RGB8_OES:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_LUMINANCE:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_LUMINANCE16F_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_LUMINANCE32F_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_LUMINANCE8_ALPHA8_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_LUMINANCE8_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_LUMINANCE_ALPHA:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_LUMINANCE_ALPHA16F_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_LUMINANCE_ALPHA32F_EXT:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_NONE:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R11F_G11F_B10F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R11G11B10_FLOAT,
                                                                              DXGI_FORMAT_R11G11B10_FLOAT,
                                                                              DXGI_FORMAT_R11G11B10_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R16F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16_FLOAT,
                                                                              DXGI_FORMAT_R16_FLOAT,
                                                                              DXGI_FORMAT_R16_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R16I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16_SINT,
                                                                              DXGI_FORMAT_R16_SINT,
                                                                              DXGI_FORMAT_R16_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R16UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16_UINT,
                                                                              DXGI_FORMAT_R16_UINT,
                                                                              DXGI_FORMAT_R16_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R32F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32_FLOAT,
                                                                              DXGI_FORMAT_R32_FLOAT,
                                                                              DXGI_FORMAT_R32_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R32I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32_SINT,
                                                                              DXGI_FORMAT_R32_SINT,
                                                                              DXGI_FORMAT_R32_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R32UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32_UINT,
                                                                              DXGI_FORMAT_R32_UINT,
                                                                              DXGI_FORMAT_R32_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R8:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8_UNORM,
                                                                              DXGI_FORMAT_R8_UNORM,
                                                                              DXGI_FORMAT_R8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R8I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8_SINT,
                                                                              DXGI_FORMAT_R8_SINT,
                                                                              DXGI_FORMAT_R8_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R8UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8_UINT,
                                                                              DXGI_FORMAT_R8_UINT,
                                                                              DXGI_FORMAT_R8_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_R8_SNORM:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8_SNORM,
                                                                              DXGI_FORMAT_R8_SNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG16F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16_FLOAT,
                                                                              DXGI_FORMAT_R16G16_FLOAT,
                                                                              DXGI_FORMAT_R16G16_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG16I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16_SINT,
                                                                              DXGI_FORMAT_R16G16_SINT,
                                                                              DXGI_FORMAT_R16G16_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG16UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16_UINT,
                                                                              DXGI_FORMAT_R16G16_UINT,
                                                                              DXGI_FORMAT_R16G16_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG32F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32_FLOAT,
                                                                              DXGI_FORMAT_R32G32_FLOAT,
                                                                              DXGI_FORMAT_R32G32_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG32I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32_SINT,
                                                                              DXGI_FORMAT_R32G32_SINT,
                                                                              DXGI_FORMAT_R32G32_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG32UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32_UINT,
                                                                              DXGI_FORMAT_R32G32_UINT,
                                                                              DXGI_FORMAT_R32G32_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG8:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8_UNORM,
                                                                              DXGI_FORMAT_R8G8_UNORM,
                                                                              DXGI_FORMAT_R8G8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG8I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8_SINT,
                                                                              DXGI_FORMAT_R8G8_SINT,
                                                                              DXGI_FORMAT_R8G8_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG8UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8_UINT,
                                                                              DXGI_FORMAT_R8G8_UINT,
                                                                              DXGI_FORMAT_R8G8_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RG8_SNORM:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8_SNORM,
                                                                              DXGI_FORMAT_R8G8_SNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB10_A2:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R10G10B10A2_UNORM,
                                                                              DXGI_FORMAT_R10G10B10A2_UNORM,
                                                                              DXGI_FORMAT_R10G10B10A2_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB10_A2UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R10G10B10A2_UINT,
                                                                              DXGI_FORMAT_R10G10B10A2_UINT,
                                                                              DXGI_FORMAT_R10G10B10A2_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB16F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB16I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_SINT,
                                                                              DXGI_FORMAT_R16G16B16A16_SINT,
                                                                              DXGI_FORMAT_R16G16B16A16_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB16UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_UINT,
                                                                              DXGI_FORMAT_R16G16B16A16_UINT,
                                                                              DXGI_FORMAT_R16G16B16A16_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB32F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB32I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_SINT,
                                                                              DXGI_FORMAT_R32G32B32A32_SINT,
                                                                              DXGI_FORMAT_R32G32B32A32_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB32UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_UINT,
                                                                              DXGI_FORMAT_R32G32B32A32_UINT,
                                                                              DXGI_FORMAT_R32G32B32A32_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB565:
        {
            if (SupportsFormat<DXGI_FORMAT_B5G6R5_UNORM,false>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else if (SupportsFormat<DXGI_FORMAT_B5G6R5_UNORM,true>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_B5G6R5_UNORM,
                                                                              DXGI_FORMAT_B5G6R5_UNORM,
                                                                              DXGI_FORMAT_B5G6R5_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB5_A1:
        {
            if (SupportsFormat<DXGI_FORMAT_B5G5R5A1_UNORM,false>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else if (SupportsFormat<DXGI_FORMAT_B5G5R5A1_UNORM,true>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_B5G5R5A1_UNORM,
                                                                              DXGI_FORMAT_B5G5R5A1_UNORM,
                                                                              DXGI_FORMAT_B5G5R5A1_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB8:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB8I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_SINT,
                                                                              DXGI_FORMAT_R8G8B8A8_SINT,
                                                                              DXGI_FORMAT_R8G8B8A8_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB8UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UINT,
                                                                              DXGI_FORMAT_R8G8B8A8_UINT,
                                                                              DXGI_FORMAT_R8G8B8A8_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB8_SNORM:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_SNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_SNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGB9_E5:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R9G9B9E5_SHAREDEXP,
                                                                              DXGI_FORMAT_R9G9B9E5_SHAREDEXP,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA16F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_R16G16B16A16_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA16I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_SINT,
                                                                              DXGI_FORMAT_R16G16B16A16_SINT,
                                                                              DXGI_FORMAT_R16G16B16A16_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA16UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R16G16B16A16_UINT,
                                                                              DXGI_FORMAT_R16G16B16A16_UINT,
                                                                              DXGI_FORMAT_R16G16B16A16_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA32F:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_R32G32B32A32_FLOAT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA32I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_SINT,
                                                                              DXGI_FORMAT_R32G32B32A32_SINT,
                                                                              DXGI_FORMAT_R32G32B32A32_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA32UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R32G32B32A32_UINT,
                                                                              DXGI_FORMAT_R32G32B32A32_UINT,
                                                                              DXGI_FORMAT_R32G32B32A32_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA4:
        {
            if (SupportsFormat<DXGI_FORMAT_B4G4R4A4_UNORM,false>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else if (SupportsFormat<DXGI_FORMAT_B4G4R4A4_UNORM,true>(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_B4G4R4A4_UNORM,
                                                                              DXGI_FORMAT_B4G4R4A4_UNORM,
                                                                              DXGI_FORMAT_B4G4R4A4_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA8:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA8I:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_SINT,
                                                                              DXGI_FORMAT_R8G8B8A8_SINT,
                                                                              DXGI_FORMAT_R8G8B8A8_SINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA8UI:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UINT,
                                                                              DXGI_FORMAT_R8G8B8A8_UINT,
                                                                              DXGI_FORMAT_R8G8B8A8_UINT,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_RGBA8_SNORM:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_SNORM,
                                                                              DXGI_FORMAT_R8G8B8A8_SNORM,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_SRGB8:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_SRGB8_ALPHA8:
        {
            if (AnyDevice(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_R8G8B8A8_UNORM_SRGB,
                                                                              DXGI_FORMAT_UNKNOWN);
                return textureFormat;
            }
            else
            {
                break;
            }
        }
        case GL_STENCIL_INDEX8:
        {
            if (OnlyFL9_3(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT);
                return textureFormat;
            }
            else if (OnlyFL10Plus(renderer11DeviceCaps))
            {
                static const TextureFormat textureFormat = GetD3D11FormatInfo(internalFormat,
                                                                              DXGI_FORMAT_R24G8_TYPELESS,
                                                                              DXGI_FORMAT_X24_TYPELESS_G8_UINT,
                                                                              DXGI_FORMAT_UNKNOWN,
                                                                              DXGI_FORMAT_D24_UNORM_S8_UINT);
                return textureFormat;
            }
            else
            {
                break;
            }
        }

        default:
            break;
    }
    // clang-format on

    static const TextureFormat defaultInfo;
    return defaultInfo;
}  // GetTextureFormatInfo

}  // namespace d3d11

}  // namespace rx
