// Code generated by smithy-go-codegen DO NOT EDIT.

package restxmlwithnamespace

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/internal/protocoltest/restxmlwithnamespace/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestxml_serializeOpSimpleScalarProperties struct {
}

func (*awsRestxml_serializeOpSimpleScalarProperties) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpSimpleScalarProperties) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SimpleScalarPropertiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/SimpleScalarProperties")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsSimpleScalarPropertiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "SimpleScalarPropertiesInputOutput",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "https://example.com"))
	if err := awsRestxml_serializeOpDocumentSimpleScalarPropertiesInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsSimpleScalarPropertiesInput(v *SimpleScalarPropertiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Foo != nil && len(*v.Foo) > 0 {
		locationName := "X-Foo"
		encoder.SetHeader(locationName).String(*v.Foo)
	}

	return nil
}

func awsRestxml_serializeOpDocumentSimpleScalarPropertiesInput(v *SimpleScalarPropertiesInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ByteValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "byteValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Byte(*v.ByteValue)
	}
	if v.DoubleValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DoubleDribble",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		switch {
		case math.IsNaN(*v.DoubleValue):
			el.String("NaN")

		case math.IsInf(*v.DoubleValue, 1):
			el.String("Infinity")

		case math.IsInf(*v.DoubleValue, -1):
			el.String("-Infinity")

		default:
			el.Double(*v.DoubleValue)

		}
	}
	if v.FalseBooleanValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "falseBooleanValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.FalseBooleanValue)
	}
	if v.FloatValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "floatValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		switch {
		case math.IsNaN(float64(*v.FloatValue)):
			el.String("NaN")

		case math.IsInf(float64(*v.FloatValue), 1):
			el.String("Infinity")

		case math.IsInf(float64(*v.FloatValue), -1):
			el.String("-Infinity")

		default:
			el.Float(*v.FloatValue)

		}
	}
	if v.IntegerValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "integerValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.IntegerValue)
	}
	if v.LongValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "longValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.LongValue)
	}
	if v.Nested != nil {
		rootAttr := []smithyxml.Attr{}
		rootAttr = append(rootAttr, smithyxml.NewNamespaceAttribute("xsi", "https://example.com"))
		if v.Nested.AttrField != nil {
			var av string
			av = *v.Nested.AttrField
			rootAttr = append(rootAttr, smithyxml.NewAttribute("xsi:someName", av))
		}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Nested",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNestedWithNamespace(v.Nested, el); err != nil {
			return err
		}
	}
	if v.ShortValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "shortValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Short(*v.ShortValue)
	}
	if v.StringValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "stringValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.StringValue)
	}
	if v.TrueBooleanValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "trueBooleanValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.TrueBooleanValue)
	}
	return nil
}

func awsRestxml_serializeDocumentNestedWithNamespace(v *types.NestedWithNamespace, value smithyxml.Value) error {
	defer value.Close()
	return nil
}
