// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfrontkeyvaluestore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new key value pair or replaces the value of an existing key.
func (c *Client) PutKey(ctx context.Context, params *PutKeyInput, optFns ...func(*Options)) (*PutKeyOutput, error) {
	if params == nil {
		params = &PutKeyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutKey", params, optFns, c.addOperationPutKeyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutKeyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// A key value pair.
type PutKeyInput struct {

	// The current version (ETag) of the Key Value Store that you are putting keys
	// into, which you can get using DescribeKeyValueStore.
	//
	// This member is required.
	IfMatch *string

	// The key to put.
	//
	// This member is required.
	Key *string

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// This member is required.
	KvsARN *string

	// The value to put.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

func (in *PutKeyInput) bindEndpointParams(p *EndpointParameters) {
	p.KvsARN = in.KvsARN

}

// Metadata information about a Key Value Store.
type PutKeyOutput struct {

	// The current version identifier of the Key Value Store after the successful put.
	//
	// This member is required.
	ETag *string

	// Number of key value pairs in the Key Value Store after the successful put.
	//
	// This member is required.
	ItemCount *int32

	// Total size of the Key Value Store after the successful put, in bytes.
	//
	// This member is required.
	TotalSizeInBytes *int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutKeyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutKey{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutKey{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutKey"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutKeyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutKey(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutKey(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutKey",
	}
}
