// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearch

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/opensearch/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcceptInboundConnection struct {
}

func (*validateOpAcceptInboundConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptInboundConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptInboundConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptInboundConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddDataSource struct {
}

func (*validateOpAddDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddTags struct {
}

func (*validateOpAddTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAssociatePackage struct {
}

func (*validateOpAssociatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAuthorizeVpcEndpointAccess struct {
}

func (*validateOpAuthorizeVpcEndpointAccess) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAuthorizeVpcEndpointAccess) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AuthorizeVpcEndpointAccessInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAuthorizeVpcEndpointAccessInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelServiceSoftwareUpdate struct {
}

func (*validateOpCancelServiceSoftwareUpdate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelServiceSoftwareUpdate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelServiceSoftwareUpdateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelServiceSoftwareUpdateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDomain struct {
}

func (*validateOpCreateDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateOutboundConnection struct {
}

func (*validateOpCreateOutboundConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateOutboundConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateOutboundConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateOutboundConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePackage struct {
}

func (*validateOpCreatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVpcEndpoint struct {
}

func (*validateOpCreateVpcEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVpcEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVpcEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVpcEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDataSource struct {
}

func (*validateOpDeleteDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDomain struct {
}

func (*validateOpDeleteDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInboundConnection struct {
}

func (*validateOpDeleteInboundConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInboundConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInboundConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInboundConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteOutboundConnection struct {
}

func (*validateOpDeleteOutboundConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteOutboundConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteOutboundConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteOutboundConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePackage struct {
}

func (*validateOpDeletePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVpcEndpoint struct {
}

func (*validateOpDeleteVpcEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVpcEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVpcEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVpcEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDomainAutoTunes struct {
}

func (*validateOpDescribeDomainAutoTunes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDomainAutoTunes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDomainAutoTunesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDomainAutoTunesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDomainChangeProgress struct {
}

func (*validateOpDescribeDomainChangeProgress) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDomainChangeProgress) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDomainChangeProgressInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDomainChangeProgressInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDomainConfig struct {
}

func (*validateOpDescribeDomainConfig) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDomainConfig) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDomainConfigInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDomainConfigInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDomainHealth struct {
}

func (*validateOpDescribeDomainHealth) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDomainHealth) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDomainHealthInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDomainHealthInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDomain struct {
}

func (*validateOpDescribeDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDomainNodes struct {
}

func (*validateOpDescribeDomainNodes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDomainNodes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDomainNodesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDomainNodesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDomains struct {
}

func (*validateOpDescribeDomains) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDomains) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDomainsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDomainsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDryRunProgress struct {
}

func (*validateOpDescribeDryRunProgress) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDryRunProgress) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDryRunProgressInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDryRunProgressInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeInstanceTypeLimits struct {
}

func (*validateOpDescribeInstanceTypeLimits) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeInstanceTypeLimits) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeInstanceTypeLimitsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeInstanceTypeLimitsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeVpcEndpoints struct {
}

func (*validateOpDescribeVpcEndpoints) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeVpcEndpoints) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeVpcEndpointsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeVpcEndpointsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDissociatePackage struct {
}

func (*validateOpDissociatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDissociatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DissociatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDissociatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDataSource struct {
}

func (*validateOpGetDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDomainMaintenanceStatus struct {
}

func (*validateOpGetDomainMaintenanceStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDomainMaintenanceStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDomainMaintenanceStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDomainMaintenanceStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPackageVersionHistory struct {
}

func (*validateOpGetPackageVersionHistory) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPackageVersionHistory) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPackageVersionHistoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPackageVersionHistoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetUpgradeHistory struct {
}

func (*validateOpGetUpgradeHistory) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetUpgradeHistory) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetUpgradeHistoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetUpgradeHistoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetUpgradeStatus struct {
}

func (*validateOpGetUpgradeStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetUpgradeStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetUpgradeStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetUpgradeStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDataSources struct {
}

func (*validateOpListDataSources) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDataSources) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDataSourcesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDataSourcesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDomainMaintenances struct {
}

func (*validateOpListDomainMaintenances) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDomainMaintenances) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDomainMaintenancesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDomainMaintenancesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDomainsForPackage struct {
}

func (*validateOpListDomainsForPackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDomainsForPackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDomainsForPackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDomainsForPackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListInstanceTypeDetails struct {
}

func (*validateOpListInstanceTypeDetails) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListInstanceTypeDetails) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListInstanceTypeDetailsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListInstanceTypeDetailsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPackagesForDomain struct {
}

func (*validateOpListPackagesForDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPackagesForDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPackagesForDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPackagesForDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListScheduledActions struct {
}

func (*validateOpListScheduledActions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListScheduledActions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListScheduledActionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListScheduledActionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTags struct {
}

func (*validateOpListTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListVpcEndpointAccess struct {
}

func (*validateOpListVpcEndpointAccess) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListVpcEndpointAccess) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListVpcEndpointAccessInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListVpcEndpointAccessInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListVpcEndpointsForDomain struct {
}

func (*validateOpListVpcEndpointsForDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListVpcEndpointsForDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListVpcEndpointsForDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListVpcEndpointsForDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPurchaseReservedInstanceOffering struct {
}

func (*validateOpPurchaseReservedInstanceOffering) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPurchaseReservedInstanceOffering) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PurchaseReservedInstanceOfferingInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPurchaseReservedInstanceOfferingInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRejectInboundConnection struct {
}

func (*validateOpRejectInboundConnection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRejectInboundConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RejectInboundConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRejectInboundConnectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveTags struct {
}

func (*validateOpRemoveTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRevokeVpcEndpointAccess struct {
}

func (*validateOpRevokeVpcEndpointAccess) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRevokeVpcEndpointAccess) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RevokeVpcEndpointAccessInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRevokeVpcEndpointAccessInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartDomainMaintenance struct {
}

func (*validateOpStartDomainMaintenance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartDomainMaintenance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartDomainMaintenanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartDomainMaintenanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartServiceSoftwareUpdate struct {
}

func (*validateOpStartServiceSoftwareUpdate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartServiceSoftwareUpdate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartServiceSoftwareUpdateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartServiceSoftwareUpdateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDataSource struct {
}

func (*validateOpUpdateDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDomainConfig struct {
}

func (*validateOpUpdateDomainConfig) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDomainConfig) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDomainConfigInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDomainConfigInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePackage struct {
}

func (*validateOpUpdatePackage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePackage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePackageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePackageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateScheduledAction struct {
}

func (*validateOpUpdateScheduledAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateScheduledAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateScheduledActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateScheduledActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateVpcEndpoint struct {
}

func (*validateOpUpdateVpcEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateVpcEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateVpcEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateVpcEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpgradeDomain struct {
}

func (*validateOpUpgradeDomain) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpgradeDomain) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpgradeDomainInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpgradeDomainInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcceptInboundConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptInboundConnection{}, middleware.After)
}

func addOpAddDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddDataSource{}, middleware.After)
}

func addOpAddTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddTags{}, middleware.After)
}

func addOpAssociatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociatePackage{}, middleware.After)
}

func addOpAuthorizeVpcEndpointAccessValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAuthorizeVpcEndpointAccess{}, middleware.After)
}

func addOpCancelServiceSoftwareUpdateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelServiceSoftwareUpdate{}, middleware.After)
}

func addOpCreateDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDomain{}, middleware.After)
}

func addOpCreateOutboundConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateOutboundConnection{}, middleware.After)
}

func addOpCreatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePackage{}, middleware.After)
}

func addOpCreateVpcEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVpcEndpoint{}, middleware.After)
}

func addOpDeleteDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDataSource{}, middleware.After)
}

func addOpDeleteDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDomain{}, middleware.After)
}

func addOpDeleteInboundConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInboundConnection{}, middleware.After)
}

func addOpDeleteOutboundConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteOutboundConnection{}, middleware.After)
}

func addOpDeletePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePackage{}, middleware.After)
}

func addOpDeleteVpcEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVpcEndpoint{}, middleware.After)
}

func addOpDescribeDomainAutoTunesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDomainAutoTunes{}, middleware.After)
}

func addOpDescribeDomainChangeProgressValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDomainChangeProgress{}, middleware.After)
}

func addOpDescribeDomainConfigValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDomainConfig{}, middleware.After)
}

func addOpDescribeDomainHealthValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDomainHealth{}, middleware.After)
}

func addOpDescribeDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDomain{}, middleware.After)
}

func addOpDescribeDomainNodesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDomainNodes{}, middleware.After)
}

func addOpDescribeDomainsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDomains{}, middleware.After)
}

func addOpDescribeDryRunProgressValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDryRunProgress{}, middleware.After)
}

func addOpDescribeInstanceTypeLimitsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeInstanceTypeLimits{}, middleware.After)
}

func addOpDescribeVpcEndpointsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeVpcEndpoints{}, middleware.After)
}

func addOpDissociatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDissociatePackage{}, middleware.After)
}

func addOpGetDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataSource{}, middleware.After)
}

func addOpGetDomainMaintenanceStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDomainMaintenanceStatus{}, middleware.After)
}

func addOpGetPackageVersionHistoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPackageVersionHistory{}, middleware.After)
}

func addOpGetUpgradeHistoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetUpgradeHistory{}, middleware.After)
}

func addOpGetUpgradeStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetUpgradeStatus{}, middleware.After)
}

func addOpListDataSourcesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDataSources{}, middleware.After)
}

func addOpListDomainMaintenancesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDomainMaintenances{}, middleware.After)
}

func addOpListDomainsForPackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDomainsForPackage{}, middleware.After)
}

func addOpListInstanceTypeDetailsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListInstanceTypeDetails{}, middleware.After)
}

func addOpListPackagesForDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPackagesForDomain{}, middleware.After)
}

func addOpListScheduledActionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListScheduledActions{}, middleware.After)
}

func addOpListTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTags{}, middleware.After)
}

func addOpListVpcEndpointAccessValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListVpcEndpointAccess{}, middleware.After)
}

func addOpListVpcEndpointsForDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListVpcEndpointsForDomain{}, middleware.After)
}

func addOpPurchaseReservedInstanceOfferingValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPurchaseReservedInstanceOffering{}, middleware.After)
}

func addOpRejectInboundConnectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRejectInboundConnection{}, middleware.After)
}

func addOpRemoveTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveTags{}, middleware.After)
}

func addOpRevokeVpcEndpointAccessValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRevokeVpcEndpointAccess{}, middleware.After)
}

func addOpStartDomainMaintenanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartDomainMaintenance{}, middleware.After)
}

func addOpStartServiceSoftwareUpdateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartServiceSoftwareUpdate{}, middleware.After)
}

func addOpUpdateDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDataSource{}, middleware.After)
}

func addOpUpdateDomainConfigValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDomainConfig{}, middleware.After)
}

func addOpUpdatePackageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePackage{}, middleware.After)
}

func addOpUpdateScheduledActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateScheduledAction{}, middleware.After)
}

func addOpUpdateVpcEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateVpcEndpoint{}, middleware.After)
}

func addOpUpgradeDomainValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpgradeDomain{}, middleware.After)
}

func validateAdvancedSecurityOptionsInput(v *types.AdvancedSecurityOptionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AdvancedSecurityOptionsInput"}
	if v.SAMLOptions != nil {
		if err := validateSAMLOptionsInput(v.SAMLOptions); err != nil {
			invalidParams.AddNested("SAMLOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAWSDomainInformation(v *types.AWSDomainInformation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AWSDomainInformation"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClusterConfig(v *types.ClusterConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClusterConfig"}
	if v.ColdStorageOptions != nil {
		if err := validateColdStorageOptions(v.ColdStorageOptions); err != nil {
			invalidParams.AddNested("ColdStorageOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateColdStorageOptions(v *types.ColdStorageOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ColdStorageOptions"}
	if v.Enabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Enabled"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDomainInformationContainer(v *types.DomainInformationContainer) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DomainInformationContainer"}
	if v.AWSDomainInformation != nil {
		if err := validateAWSDomainInformation(v.AWSDomainInformation); err != nil {
			invalidParams.AddNested("AWSDomainInformation", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOffPeakWindow(v *types.OffPeakWindow) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OffPeakWindow"}
	if v.WindowStartTime != nil {
		if err := validateWindowStartTime(v.WindowStartTime); err != nil {
			invalidParams.AddNested("WindowStartTime", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOffPeakWindowOptions(v *types.OffPeakWindowOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OffPeakWindowOptions"}
	if v.OffPeakWindow != nil {
		if err := validateOffPeakWindow(v.OffPeakWindow); err != nil {
			invalidParams.AddNested("OffPeakWindow", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAMLIdp(v *types.SAMLIdp) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAMLIdp"}
	if v.MetadataContent == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetadataContent"))
	}
	if v.EntityId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EntityId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAMLOptionsInput(v *types.SAMLOptionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAMLOptionsInput"}
	if v.Idp != nil {
		if err := validateSAMLIdp(v.Idp); err != nil {
			invalidParams.AddNested("Idp", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWindowStartTime(v *types.WindowStartTime) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WindowStartTime"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptInboundConnectionInput(v *AcceptInboundConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptInboundConnectionInput"}
	if v.ConnectionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddDataSourceInput(v *AddDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddDataSourceInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.DataSourceType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSourceType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddTagsInput(v *AddTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddTagsInput"}
	if v.ARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ARN"))
	}
	if v.TagList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagList"))
	} else if v.TagList != nil {
		if err := validateTagList(v.TagList); err != nil {
			invalidParams.AddNested("TagList", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociatePackageInput(v *AssociatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociatePackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAuthorizeVpcEndpointAccessInput(v *AuthorizeVpcEndpointAccessInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AuthorizeVpcEndpointAccessInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.Account == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Account"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelServiceSoftwareUpdateInput(v *CancelServiceSoftwareUpdateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelServiceSoftwareUpdateInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDomainInput(v *CreateDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.ClusterConfig != nil {
		if err := validateClusterConfig(v.ClusterConfig); err != nil {
			invalidParams.AddNested("ClusterConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.AdvancedSecurityOptions != nil {
		if err := validateAdvancedSecurityOptionsInput(v.AdvancedSecurityOptions); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.TagList != nil {
		if err := validateTagList(v.TagList); err != nil {
			invalidParams.AddNested("TagList", err.(smithy.InvalidParamsError))
		}
	}
	if v.OffPeakWindowOptions != nil {
		if err := validateOffPeakWindowOptions(v.OffPeakWindowOptions); err != nil {
			invalidParams.AddNested("OffPeakWindowOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateOutboundConnectionInput(v *CreateOutboundConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateOutboundConnectionInput"}
	if v.LocalDomainInfo == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LocalDomainInfo"))
	} else if v.LocalDomainInfo != nil {
		if err := validateDomainInformationContainer(v.LocalDomainInfo); err != nil {
			invalidParams.AddNested("LocalDomainInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.RemoteDomainInfo == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RemoteDomainInfo"))
	} else if v.RemoteDomainInfo != nil {
		if err := validateDomainInformationContainer(v.RemoteDomainInfo); err != nil {
			invalidParams.AddNested("RemoteDomainInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConnectionAlias == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionAlias"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePackageInput(v *CreatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePackageInput"}
	if v.PackageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageName"))
	}
	if len(v.PackageType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PackageType"))
	}
	if v.PackageSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageSource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVpcEndpointInput(v *CreateVpcEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVpcEndpointInput"}
	if v.DomainArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainArn"))
	}
	if v.VpcOptions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcOptions"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDataSourceInput(v *DeleteDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDataSourceInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDomainInput(v *DeleteDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInboundConnectionInput(v *DeleteInboundConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInboundConnectionInput"}
	if v.ConnectionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteOutboundConnectionInput(v *DeleteOutboundConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteOutboundConnectionInput"}
	if v.ConnectionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePackageInput(v *DeletePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVpcEndpointInput(v *DeleteVpcEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVpcEndpointInput"}
	if v.VpcEndpointId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcEndpointId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDomainAutoTunesInput(v *DescribeDomainAutoTunesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDomainAutoTunesInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDomainChangeProgressInput(v *DescribeDomainChangeProgressInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDomainChangeProgressInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDomainConfigInput(v *DescribeDomainConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDomainConfigInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDomainHealthInput(v *DescribeDomainHealthInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDomainHealthInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDomainInput(v *DescribeDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDomainNodesInput(v *DescribeDomainNodesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDomainNodesInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDomainsInput(v *DescribeDomainsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDomainsInput"}
	if v.DomainNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDryRunProgressInput(v *DescribeDryRunProgressInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDryRunProgressInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeInstanceTypeLimitsInput(v *DescribeInstanceTypeLimitsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeInstanceTypeLimitsInput"}
	if len(v.InstanceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceType"))
	}
	if v.EngineVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EngineVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeVpcEndpointsInput(v *DescribeVpcEndpointsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeVpcEndpointsInput"}
	if v.VpcEndpointIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcEndpointIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDissociatePackageInput(v *DissociatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DissociatePackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataSourceInput(v *GetDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataSourceInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDomainMaintenanceStatusInput(v *GetDomainMaintenanceStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDomainMaintenanceStatusInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.MaintenanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaintenanceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPackageVersionHistoryInput(v *GetPackageVersionHistoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPackageVersionHistoryInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetUpgradeHistoryInput(v *GetUpgradeHistoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetUpgradeHistoryInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetUpgradeStatusInput(v *GetUpgradeStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetUpgradeStatusInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDataSourcesInput(v *ListDataSourcesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDataSourcesInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDomainMaintenancesInput(v *ListDomainMaintenancesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDomainMaintenancesInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDomainsForPackageInput(v *ListDomainsForPackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDomainsForPackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListInstanceTypeDetailsInput(v *ListInstanceTypeDetailsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListInstanceTypeDetailsInput"}
	if v.EngineVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EngineVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPackagesForDomainInput(v *ListPackagesForDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPackagesForDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListScheduledActionsInput(v *ListScheduledActionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListScheduledActionsInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsInput(v *ListTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsInput"}
	if v.ARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListVpcEndpointAccessInput(v *ListVpcEndpointAccessInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListVpcEndpointAccessInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListVpcEndpointsForDomainInput(v *ListVpcEndpointsForDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListVpcEndpointsForDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPurchaseReservedInstanceOfferingInput(v *PurchaseReservedInstanceOfferingInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PurchaseReservedInstanceOfferingInput"}
	if v.ReservedInstanceOfferingId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReservedInstanceOfferingId"))
	}
	if v.ReservationName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReservationName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRejectInboundConnectionInput(v *RejectInboundConnectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RejectInboundConnectionInput"}
	if v.ConnectionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveTagsInput(v *RemoveTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveTagsInput"}
	if v.ARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRevokeVpcEndpointAccessInput(v *RevokeVpcEndpointAccessInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RevokeVpcEndpointAccessInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.Account == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Account"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartDomainMaintenanceInput(v *StartDomainMaintenanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartDomainMaintenanceInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartServiceSoftwareUpdateInput(v *StartServiceSoftwareUpdateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartServiceSoftwareUpdateInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDataSourceInput(v *UpdateDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDataSourceInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.DataSourceType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSourceType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDomainConfigInput(v *UpdateDomainConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDomainConfigInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.ClusterConfig != nil {
		if err := validateClusterConfig(v.ClusterConfig); err != nil {
			invalidParams.AddNested("ClusterConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.AdvancedSecurityOptions != nil {
		if err := validateAdvancedSecurityOptionsInput(v.AdvancedSecurityOptions); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.OffPeakWindowOptions != nil {
		if err := validateOffPeakWindowOptions(v.OffPeakWindowOptions); err != nil {
			invalidParams.AddNested("OffPeakWindowOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePackageInput(v *UpdatePackageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePackageInput"}
	if v.PackageID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageID"))
	}
	if v.PackageSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PackageSource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateScheduledActionInput(v *UpdateScheduledActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateScheduledActionInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.ActionID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionID"))
	}
	if len(v.ActionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ActionType"))
	}
	if len(v.ScheduleAt) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ScheduleAt"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateVpcEndpointInput(v *UpdateVpcEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateVpcEndpointInput"}
	if v.VpcEndpointId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcEndpointId"))
	}
	if v.VpcOptions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcOptions"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpgradeDomainInput(v *UpgradeDomainInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpgradeDomainInput"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.TargetVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
