// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The properties (metadata) of a column.
type ColumnMetadata struct {

	// The default value of the column.
	ColumnDefault *string

	// A value that indicates whether the column is case-sensitive.
	IsCaseSensitive bool

	// A value that indicates whether the column contains currency values.
	IsCurrency bool

	// A value that indicates whether an integer column is signed.
	IsSigned bool

	// The label for the column.
	Label *string

	// The length of the column.
	Length int32

	// The name of the column.
	Name *string

	// A value that indicates whether the column is nullable.
	Nullable int32

	// The precision value of a decimal number column.
	Precision int32

	// The scale value of a decimal number column.
	Scale int32

	// The name of the schema that contains the table that includes the column.
	SchemaName *string

	// The name of the table that includes the column.
	TableName *string

	// The database-specific data type of the column.
	TypeName *string

	noSmithyDocumentSerde
}

// A data value in a column.
//
// The following types satisfy this interface:
//
//	FieldMemberBlobValue
//	FieldMemberBooleanValue
//	FieldMemberDoubleValue
//	FieldMemberIsNull
//	FieldMemberLongValue
//	FieldMemberStringValue
type Field interface {
	isField()
}

// A value of the BLOB data type.
type FieldMemberBlobValue struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*FieldMemberBlobValue) isField() {}

// A value of the Boolean data type.
type FieldMemberBooleanValue struct {
	Value bool

	noSmithyDocumentSerde
}

func (*FieldMemberBooleanValue) isField() {}

// A value of the double data type.
type FieldMemberDoubleValue struct {
	Value float64

	noSmithyDocumentSerde
}

func (*FieldMemberDoubleValue) isField() {}

// A value that indicates whether the data is NULL.
type FieldMemberIsNull struct {
	Value bool

	noSmithyDocumentSerde
}

func (*FieldMemberIsNull) isField() {}

// A value of the long data type.
type FieldMemberLongValue struct {
	Value int64

	noSmithyDocumentSerde
}

func (*FieldMemberLongValue) isField() {}

// A value of the string data type.
type FieldMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*FieldMemberStringValue) isField() {}

// A parameter used in a SQL statement.
type SqlParameter struct {

	// The name of the parameter.
	//
	// This member is required.
	Name *string

	// The value of the parameter. Amazon Redshift implicitly converts to the proper
	// data type. For more information, see Data types (https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html)
	// in the Amazon Redshift Database Developer Guide.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The SQL statement to run.
type StatementData struct {

	// The SQL statement identifier. This value is a universally unique identifier
	// (UUID) generated by Amazon Redshift Data API.
	//
	// This member is required.
	Id *string

	// The date and time (UTC) the statement was created.
	CreatedAt *time.Time

	// A value that indicates whether the statement is a batch query request.
	IsBatchStatement *bool

	// The parameters used in a SQL statement.
	QueryParameters []SqlParameter

	// The SQL statement.
	QueryString *string

	// One or more SQL statements. Each query string in the array corresponds to one
	// of the queries in a batch query request.
	QueryStrings []string

	// The name or Amazon Resource Name (ARN) of the secret that enables access to the
	// database.
	SecretArn *string

	// The name of the SQL statement.
	StatementName *string

	// The status of the SQL statement. An example is the that the SQL statement
	// finished.
	Status StatusString

	// The date and time (UTC) that the statement metadata was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information about an SQL statement.
type SubStatementData struct {

	// The identifier of the SQL statement. This value is a universally unique
	// identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the
	// number of the SQL statement. For example, d9b6c0c9-0747-4bf4-b142-e8883122f766:2
	// has a suffix of :2 that indicates the second SQL statement of a batch query.
	//
	// This member is required.
	Id *string

	// The date and time (UTC) the statement was created.
	CreatedAt *time.Time

	// The amount of time in nanoseconds that the statement ran.
	Duration int64

	// The error message from the cluster if the SQL statement encountered an error
	// while running.
	Error *string

	// A value that indicates whether the statement has a result set. The result set
	// can be empty. The value is true for an empty result set.
	HasResultSet *bool

	// The SQL statement text.
	QueryString *string

	// The SQL statement identifier. This value is a universally unique identifier
	// (UUID) generated by Amazon Redshift Data API.
	RedshiftQueryId int64

	// Either the number of rows returned from the SQL statement or the number of rows
	// affected. If result size is greater than zero, the result rows can be the number
	// of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and
	// others. A -1 indicates the value is null.
	ResultRows int64

	// The size in bytes of the returned results. A -1 indicates the value is null.
	ResultSize int64

	// The status of the SQL statement. An example is the that the SQL statement
	// finished.
	Status StatementStatusString

	// The date and time (UTC) that the statement metadata was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The properties of a table.
type TableMember struct {

	// The name of the table.
	Name *string

	// The schema containing the table.
	Schema *string

	// The type of the table. Possible values include TABLE, VIEW, SYSTEM TABLE,
	// GLOBAL TEMPORARY, LOCAL TEMPORARY, ALIAS, and SYNONYM.
	Type *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isField() {}
