// Code generated by smithy-go-codegen DO NOT EDIT.

package redshiftserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/redshiftserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Restores a table from a recovery point to your Amazon Redshift Serverless
// instance. You can't use this operation to restore tables with interleaved sort
// keys.
func (c *Client) RestoreTableFromRecoveryPoint(ctx context.Context, params *RestoreTableFromRecoveryPointInput, optFns ...func(*Options)) (*RestoreTableFromRecoveryPointOutput, error) {
	if params == nil {
		params = &RestoreTableFromRecoveryPointInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RestoreTableFromRecoveryPoint", params, optFns, c.addOperationRestoreTableFromRecoveryPointMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RestoreTableFromRecoveryPointOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RestoreTableFromRecoveryPointInput struct {

	// Namespace of the recovery point to restore from.
	//
	// This member is required.
	NamespaceName *string

	// The name of the table to create from the restore operation.
	//
	// This member is required.
	NewTableName *string

	// The ID of the recovery point to restore the table from.
	//
	// This member is required.
	RecoveryPointId *string

	// The name of the source database that contains the table being restored.
	//
	// This member is required.
	SourceDatabaseName *string

	// The name of the source table being restored.
	//
	// This member is required.
	SourceTableName *string

	// The workgroup to restore the table to.
	//
	// This member is required.
	WorkgroupName *string

	// Indicates whether name identifiers for database, schema, and table are case
	// sensitive. If true, the names are case sensitive. If false, the names are not
	// case sensitive. The default is false.
	ActivateCaseSensitiveIdentifier *bool

	// The name of the source schema that contains the table being restored.
	SourceSchemaName *string

	// The name of the database to restore the table to.
	TargetDatabaseName *string

	// The name of the schema to restore the table to.
	TargetSchemaName *string

	noSmithyDocumentSerde
}

type RestoreTableFromRecoveryPointOutput struct {

	// Contains information about a table restore request.
	TableRestoreStatus *types.TableRestoreStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRestoreTableFromRecoveryPointMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpRestoreTableFromRecoveryPoint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpRestoreTableFromRecoveryPoint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RestoreTableFromRecoveryPoint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRestoreTableFromRecoveryPointValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRestoreTableFromRecoveryPoint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRestoreTableFromRecoveryPoint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RestoreTableFromRecoveryPoint",
	}
}
