// Code generated by smithy-go-codegen DO NOT EDIT.

package accessanalyzer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/accessanalyzer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of findings generated by the specified analyzer. ListFindings
// and ListFindingsV2 both use access-analyzer:ListFindings in the Action element
// of an IAM policy statement. You must have permission to perform the
// access-analyzer:ListFindings action.
//
// To learn about filter keys that you can use to retrieve a list of findings, see [IAM Access Analyzer filter keys]
// in the IAM User Guide.
//
// [IAM Access Analyzer filter keys]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html
func (c *Client) ListFindingsV2(ctx context.Context, params *ListFindingsV2Input, optFns ...func(*Options)) (*ListFindingsV2Output, error) {
	if params == nil {
		params = &ListFindingsV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFindingsV2", params, optFns, c.addOperationListFindingsV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFindingsV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFindingsV2Input struct {

	// The [ARN of the analyzer] to retrieve findings from.
	//
	// [ARN of the analyzer]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources
	//
	// This member is required.
	AnalyzerArn *string

	// A filter to match for the findings to return.
	Filter map[string]types.Criterion

	// The maximum number of results to return in the response.
	MaxResults *int32

	// A token used for pagination of results returned.
	NextToken *string

	// The criteria used to sort.
	Sort *types.SortCriteria

	noSmithyDocumentSerde
}

type ListFindingsV2Output struct {

	// A list of findings retrieved from the analyzer that match the filter criteria
	// specified, if any.
	//
	// This member is required.
	Findings []types.FindingSummaryV2

	// A token used for pagination of results returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFindingsV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListFindingsV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListFindingsV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFindingsV2"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListFindingsV2ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFindingsV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListFindingsV2PaginatorOptions is the paginator options for ListFindingsV2
type ListFindingsV2PaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFindingsV2Paginator is a paginator for ListFindingsV2
type ListFindingsV2Paginator struct {
	options   ListFindingsV2PaginatorOptions
	client    ListFindingsV2APIClient
	params    *ListFindingsV2Input
	nextToken *string
	firstPage bool
}

// NewListFindingsV2Paginator returns a new ListFindingsV2Paginator
func NewListFindingsV2Paginator(client ListFindingsV2APIClient, params *ListFindingsV2Input, optFns ...func(*ListFindingsV2PaginatorOptions)) *ListFindingsV2Paginator {
	if params == nil {
		params = &ListFindingsV2Input{}
	}

	options := ListFindingsV2PaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFindingsV2Paginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFindingsV2Paginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFindingsV2 page.
func (p *ListFindingsV2Paginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFindingsV2Output, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFindingsV2(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFindingsV2APIClient is a client that implements the ListFindingsV2
// operation.
type ListFindingsV2APIClient interface {
	ListFindingsV2(context.Context, *ListFindingsV2Input, ...func(*Options)) (*ListFindingsV2Output, error)
}

var _ ListFindingsV2APIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFindingsV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFindingsV2",
	}
}
