// Code generated by smithy-go-codegen DO NOT EDIT.

package acmpca

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/acmpca/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Revokes a certificate that was issued inside Amazon Web Services Private CA. If
// you enable a certificate revocation list (CRL) when you create or update your
// private CA, information about the revoked certificates will be included in the
// CRL. Amazon Web Services Private CA writes the CRL to an S3 bucket that you
// specify. A CRL is typically updated approximately 30 minutes after a certificate
// is revoked. If for any reason the CRL update fails, Amazon Web Services Private
// CA attempts makes further attempts every 15 minutes. With Amazon CloudWatch, you
// can create alarms for the metrics CRLGenerated and MisconfiguredCRLBucket . For
// more information, see [Supported CloudWatch Metrics].
//
// Both Amazon Web Services Private CA and the IAM principal must have permission
// to write to the S3 bucket that you specify. If the IAM principal making the call
// does not have permission to write to the bucket, then an exception is thrown.
// For more information, see [Access policies for CRLs in Amazon S3].
//
// Amazon Web Services Private CA also writes revocation information to the audit
// report. For more information, see [CreateCertificateAuthorityAuditReport].
//
// You cannot revoke a root CA self-signed certificate.
//
// [Access policies for CRLs in Amazon S3]: https://docs.aws.amazon.com/privateca/latest/userguide/crl-planning.html#s3-policies
// [CreateCertificateAuthorityAuditReport]: https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html
// [Supported CloudWatch Metrics]: https://docs.aws.amazon.com/privateca/latest/userguide/PcaCloudWatch.html
func (c *Client) RevokeCertificate(ctx context.Context, params *RevokeCertificateInput, optFns ...func(*Options)) (*RevokeCertificateOutput, error) {
	if params == nil {
		params = &RevokeCertificateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RevokeCertificate", params, optFns, c.addOperationRevokeCertificateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RevokeCertificateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RevokeCertificateInput struct {

	// Amazon Resource Name (ARN) of the private CA that issued the certificate to be
	// revoked. This must be of the form:
	//
	//     arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// This member is required.
	CertificateAuthorityArn *string

	// Serial number of the certificate to be revoked. This must be in hexadecimal
	// format. You can retrieve the serial number by calling [GetCertificate]with the Amazon Resource
	// Name (ARN) of the certificate you want and the ARN of your private CA. The
	// GetCertificate action retrieves the certificate in the PEM format. You can use
	// the following OpenSSL command to list the certificate in text format and copy
	// the hexadecimal serial number.
	//
	//     openssl x509 -in file_path -text -noout
	//
	// You can also copy the serial number from the console or use the [DescribeCertificate] action in the
	// Certificate Manager API Reference.
	//
	// [DescribeCertificate]: https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html
	// [GetCertificate]: https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetCertificate.html
	//
	// This member is required.
	CertificateSerial *string

	// Specifies why you revoked the certificate.
	//
	// This member is required.
	RevocationReason types.RevocationReason

	noSmithyDocumentSerde
}

type RevokeCertificateOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRevokeCertificateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpRevokeCertificate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpRevokeCertificate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RevokeCertificate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpRevokeCertificateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRevokeCertificate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRevokeCertificate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RevokeCertificate",
	}
}
