// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of training datasets.
func (c *Client) ListTrainingDatasets(ctx context.Context, params *ListTrainingDatasetsInput, optFns ...func(*Options)) (*ListTrainingDatasetsOutput, error) {
	if params == nil {
		params = &ListTrainingDatasetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTrainingDatasets", params, optFns, c.addOperationListTrainingDatasetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTrainingDatasetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTrainingDatasetsInput struct {

	// The maximum size of the results that is returned per call.
	MaxResults *int32

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTrainingDatasetsOutput struct {

	// The training datasets that match the request.
	//
	// This member is required.
	TrainingDatasets []types.TrainingDatasetSummary

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTrainingDatasetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTrainingDatasets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTrainingDatasets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTrainingDatasets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTrainingDatasets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTrainingDatasetsPaginatorOptions is the paginator options for
// ListTrainingDatasets
type ListTrainingDatasetsPaginatorOptions struct {
	// The maximum size of the results that is returned per call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTrainingDatasetsPaginator is a paginator for ListTrainingDatasets
type ListTrainingDatasetsPaginator struct {
	options   ListTrainingDatasetsPaginatorOptions
	client    ListTrainingDatasetsAPIClient
	params    *ListTrainingDatasetsInput
	nextToken *string
	firstPage bool
}

// NewListTrainingDatasetsPaginator returns a new ListTrainingDatasetsPaginator
func NewListTrainingDatasetsPaginator(client ListTrainingDatasetsAPIClient, params *ListTrainingDatasetsInput, optFns ...func(*ListTrainingDatasetsPaginatorOptions)) *ListTrainingDatasetsPaginator {
	if params == nil {
		params = &ListTrainingDatasetsInput{}
	}

	options := ListTrainingDatasetsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTrainingDatasetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTrainingDatasetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTrainingDatasets page.
func (p *ListTrainingDatasetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTrainingDatasetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTrainingDatasets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTrainingDatasetsAPIClient is a client that implements the
// ListTrainingDatasets operation.
type ListTrainingDatasetsAPIClient interface {
	ListTrainingDatasets(context.Context, *ListTrainingDatasetsInput, ...func(*Options)) (*ListTrainingDatasetsOutput, error)
}

var _ ListTrainingDatasetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTrainingDatasets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTrainingDatasets",
	}
}
