// Code generated by smithy-go-codegen DO NOT EDIT.

package iotevents

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotevents/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves runtime information about a detector model analysis.
//
// After AWS IoT Events starts analyzing your detector model, you have up to 24
// hours to retrieve the analysis results.
func (c *Client) DescribeDetectorModelAnalysis(ctx context.Context, params *DescribeDetectorModelAnalysisInput, optFns ...func(*Options)) (*DescribeDetectorModelAnalysisOutput, error) {
	if params == nil {
		params = &DescribeDetectorModelAnalysisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDetectorModelAnalysis", params, optFns, c.addOperationDescribeDetectorModelAnalysisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDetectorModelAnalysisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeDetectorModelAnalysisInput struct {

	// The ID of the analysis result that you want to retrieve.
	//
	// This member is required.
	AnalysisId *string

	noSmithyDocumentSerde
}

type DescribeDetectorModelAnalysisOutput struct {

	// The status of the analysis activity. The status can be one of the following
	// values:
	//
	//   - RUNNING - AWS IoT Events is analyzing your detector model. This process can
	//   take several minutes to complete.
	//
	//   - COMPLETE - AWS IoT Events finished analyzing your detector model.
	//
	//   - FAILED - AWS IoT Events couldn't analyze your detector model. Try again
	//   later.
	Status types.AnalysisStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDetectorModelAnalysisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeDetectorModelAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeDetectorModelAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeDetectorModelAnalysis"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeDetectorModelAnalysisValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDetectorModelAnalysis(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeDetectorModelAnalysis(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeDetectorModelAnalysis",
	}
}
