// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAddBridgeOutputs struct {
}

func (*awsRestjson1_serializeOpAddBridgeOutputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddBridgeOutputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddBridgeOutputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/outputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddBridgeOutputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddBridgeOutputsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddBridgeOutputsInput(v *AddBridgeOutputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddBridgeOutputsInput(v *AddBridgeOutputsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfAddBridgeOutputRequest(v.Outputs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddBridgeSources struct {
}

func (*awsRestjson1_serializeOpAddBridgeSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddBridgeSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddBridgeSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/sources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddBridgeSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddBridgeSourcesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddBridgeSourcesInput(v *AddBridgeSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddBridgeSourcesInput(v *AddBridgeSourcesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfAddBridgeSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddFlowMediaStreams struct {
}

func (*awsRestjson1_serializeOpAddFlowMediaStreams) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFlowMediaStreams) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFlowMediaStreamsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/mediaStreams")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFlowMediaStreamsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFlowMediaStreamsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFlowMediaStreamsInput(v *AddFlowMediaStreamsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFlowMediaStreamsInput(v *AddFlowMediaStreamsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MediaStreams != nil {
		ok := object.Key("mediaStreams")
		if err := awsRestjson1_serializeDocument__listOfAddMediaStreamRequest(v.MediaStreams, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddFlowOutputs struct {
}

func (*awsRestjson1_serializeOpAddFlowOutputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFlowOutputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFlowOutputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/outputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFlowOutputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFlowOutputsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFlowOutputsInput(v *AddFlowOutputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFlowOutputsInput(v *AddFlowOutputsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfAddOutputRequest(v.Outputs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddFlowSources struct {
}

func (*awsRestjson1_serializeOpAddFlowSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFlowSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFlowSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFlowSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFlowSourcesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFlowSourcesInput(v *AddFlowSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFlowSourcesInput(v *AddFlowSourcesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfSetSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAddFlowVpcInterfaces struct {
}

func (*awsRestjson1_serializeOpAddFlowVpcInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddFlowVpcInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddFlowVpcInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/vpcInterfaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddFlowVpcInterfacesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddFlowVpcInterfacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddFlowVpcInterfacesInput(v *AddFlowVpcInterfacesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddFlowVpcInterfacesInput(v *AddFlowVpcInterfacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VpcInterfaces != nil {
		ok := object.Key("vpcInterfaces")
		if err := awsRestjson1_serializeDocument__listOfVpcInterfaceRequest(v.VpcInterfaces, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBridge struct {
}

func (*awsRestjson1_serializeOpCreateBridge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBridge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBridgeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBridgeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBridgeInput(v *CreateBridgeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBridgeInput(v *CreateBridgeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EgressGatewayBridge != nil {
		ok := object.Key("egressGatewayBridge")
		if err := awsRestjson1_serializeDocumentAddEgressGatewayBridgeRequest(v.EgressGatewayBridge, ok); err != nil {
			return err
		}
	}

	if v.IngressGatewayBridge != nil {
		ok := object.Key("ingressGatewayBridge")
		if err := awsRestjson1_serializeDocumentAddIngressGatewayBridgeRequest(v.IngressGatewayBridge, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfAddBridgeOutputRequest(v.Outputs, ok); err != nil {
			return err
		}
	}

	if v.PlacementArn != nil {
		ok := object.Key("placementArn")
		ok.String(*v.PlacementArn)
	}

	if v.SourceFailoverConfig != nil {
		ok := object.Key("sourceFailoverConfig")
		if err := awsRestjson1_serializeDocumentFailoverConfig(v.SourceFailoverConfig, ok); err != nil {
			return err
		}
	}

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfAddBridgeSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFlow struct {
}

func (*awsRestjson1_serializeOpCreateFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFlowInput(v *CreateFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFlowInput(v *CreateFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZone != nil {
		ok := object.Key("availabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.Entitlements != nil {
		ok := object.Key("entitlements")
		if err := awsRestjson1_serializeDocument__listOfGrantEntitlementRequest(v.Entitlements, ok); err != nil {
			return err
		}
	}

	if v.Maintenance != nil {
		ok := object.Key("maintenance")
		if err := awsRestjson1_serializeDocumentAddMaintenance(v.Maintenance, ok); err != nil {
			return err
		}
	}

	if v.MediaStreams != nil {
		ok := object.Key("mediaStreams")
		if err := awsRestjson1_serializeDocument__listOfAddMediaStreamRequest(v.MediaStreams, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfAddOutputRequest(v.Outputs, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentSetSourceRequest(v.Source, ok); err != nil {
			return err
		}
	}

	if v.SourceFailoverConfig != nil {
		ok := object.Key("sourceFailoverConfig")
		if err := awsRestjson1_serializeDocumentFailoverConfig(v.SourceFailoverConfig, ok); err != nil {
			return err
		}
	}

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocument__listOfSetSourceRequest(v.Sources, ok); err != nil {
			return err
		}
	}

	if v.VpcInterfaces != nil {
		ok := object.Key("vpcInterfaces")
		if err := awsRestjson1_serializeDocument__listOfVpcInterfaceRequest(v.VpcInterfaces, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateGateway struct {
}

func (*awsRestjson1_serializeOpCreateGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateways")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGatewayInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGatewayInput(v *CreateGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGatewayInput(v *CreateGatewayInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EgressCidrBlocks != nil {
		ok := object.Key("egressCidrBlocks")
		if err := awsRestjson1_serializeDocument__listOf__string(v.EgressCidrBlocks, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Networks != nil {
		ok := object.Key("networks")
		if err := awsRestjson1_serializeDocument__listOfGatewayNetwork(v.Networks, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBridge struct {
}

func (*awsRestjson1_serializeOpDeleteBridge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBridge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBridgeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBridgeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBridgeInput(v *DeleteBridgeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFlow struct {
}

func (*awsRestjson1_serializeOpDeleteFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFlowInput(v *DeleteFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGateway struct {
}

func (*awsRestjson1_serializeOpDeleteGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateways/{GatewayArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGatewayInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGatewayInput(v *DeleteGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayArn == nil || len(*v.GatewayArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayArn must not be empty")}
	}
	if v.GatewayArn != nil {
		if err := encoder.SetURI("GatewayArn").String(*v.GatewayArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeregisterGatewayInstance struct {
}

func (*awsRestjson1_serializeOpDeregisterGatewayInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeregisterGatewayInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterGatewayInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateway-instances/{GatewayInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeregisterGatewayInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeregisterGatewayInstanceInput(v *DeregisterGatewayInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Force != nil {
		encoder.SetQuery("force").Boolean(*v.Force)
	}

	if v.GatewayInstanceArn == nil || len(*v.GatewayInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayInstanceArn must not be empty")}
	}
	if v.GatewayInstanceArn != nil {
		if err := encoder.SetURI("GatewayInstanceArn").String(*v.GatewayInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBridge struct {
}

func (*awsRestjson1_serializeOpDescribeBridge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBridge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBridgeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBridgeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBridgeInput(v *DescribeBridgeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFlow struct {
}

func (*awsRestjson1_serializeOpDescribeFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFlowInput(v *DescribeFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFlowSourceMetadata struct {
}

func (*awsRestjson1_serializeOpDescribeFlowSourceMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFlowSourceMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFlowSourceMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source-metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFlowSourceMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFlowSourceMetadataInput(v *DescribeFlowSourceMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGateway struct {
}

func (*awsRestjson1_serializeOpDescribeGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateways/{GatewayArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGatewayInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGatewayInput(v *DescribeGatewayInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayArn == nil || len(*v.GatewayArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayArn must not be empty")}
	}
	if v.GatewayArn != nil {
		if err := encoder.SetURI("GatewayArn").String(*v.GatewayArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGatewayInstance struct {
}

func (*awsRestjson1_serializeOpDescribeGatewayInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGatewayInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGatewayInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateway-instances/{GatewayInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGatewayInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGatewayInstanceInput(v *DescribeGatewayInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayInstanceArn == nil || len(*v.GatewayInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayInstanceArn must not be empty")}
	}
	if v.GatewayInstanceArn != nil {
		if err := encoder.SetURI("GatewayInstanceArn").String(*v.GatewayInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeOffering struct {
}

func (*awsRestjson1_serializeOpDescribeOffering) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeOffering) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeOfferingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/offerings/{OfferingArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeOfferingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeOfferingInput(v *DescribeOfferingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.OfferingArn == nil || len(*v.OfferingArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OfferingArn must not be empty")}
	}
	if v.OfferingArn != nil {
		if err := encoder.SetURI("OfferingArn").String(*v.OfferingArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeReservation struct {
}

func (*awsRestjson1_serializeOpDescribeReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/reservations/{ReservationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeReservationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeReservationInput(v *DescribeReservationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReservationArn == nil || len(*v.ReservationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReservationArn must not be empty")}
	}
	if v.ReservationArn != nil {
		if err := encoder.SetURI("ReservationArn").String(*v.ReservationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGrantFlowEntitlements struct {
}

func (*awsRestjson1_serializeOpGrantFlowEntitlements) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGrantFlowEntitlements) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GrantFlowEntitlementsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/entitlements")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGrantFlowEntitlementsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGrantFlowEntitlementsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGrantFlowEntitlementsInput(v *GrantFlowEntitlementsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGrantFlowEntitlementsInput(v *GrantFlowEntitlementsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Entitlements != nil {
		ok := object.Key("entitlements")
		if err := awsRestjson1_serializeDocument__listOfGrantEntitlementRequest(v.Entitlements, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBridges struct {
}

func (*awsRestjson1_serializeOpListBridges) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBridges) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBridgesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBridgesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBridgesInput(v *ListBridgesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FilterArn != nil {
		encoder.SetQuery("filterArn").String(*v.FilterArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListEntitlements struct {
}

func (*awsRestjson1_serializeOpListEntitlements) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEntitlements) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEntitlementsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/entitlements")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEntitlementsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEntitlementsInput(v *ListEntitlementsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFlows struct {
}

func (*awsRestjson1_serializeOpListFlows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFlows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFlowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFlowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFlowsInput(v *ListFlowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGatewayInstances struct {
}

func (*awsRestjson1_serializeOpListGatewayInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGatewayInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGatewayInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateway-instances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGatewayInstancesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGatewayInstancesInput(v *ListGatewayInstancesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FilterArn != nil {
		encoder.SetQuery("filterArn").String(*v.FilterArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGateways struct {
}

func (*awsRestjson1_serializeOpListGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateways")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGatewaysInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGatewaysInput(v *ListGatewaysInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListOfferings struct {
}

func (*awsRestjson1_serializeOpListOfferings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListOfferings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListOfferingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/offerings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListOfferingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListOfferingsInput(v *ListOfferingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListReservations struct {
}

func (*awsRestjson1_serializeOpListReservations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListReservations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListReservationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/reservations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListReservationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListReservationsInput(v *ListReservationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPurchaseOffering struct {
}

func (*awsRestjson1_serializeOpPurchaseOffering) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPurchaseOffering) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurchaseOfferingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/offerings/{OfferingArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPurchaseOfferingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPurchaseOfferingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPurchaseOfferingInput(v *PurchaseOfferingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.OfferingArn == nil || len(*v.OfferingArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OfferingArn must not be empty")}
	}
	if v.OfferingArn != nil {
		if err := encoder.SetURI("OfferingArn").String(*v.OfferingArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPurchaseOfferingInput(v *PurchaseOfferingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReservationName != nil {
		ok := object.Key("reservationName")
		ok.String(*v.ReservationName)
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.String(*v.Start)
	}

	return nil
}

type awsRestjson1_serializeOpRemoveBridgeOutput struct {
}

func (*awsRestjson1_serializeOpRemoveBridgeOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveBridgeOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveBridgeOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/outputs/{OutputName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveBridgeOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveBridgeOutputInput(v *RemoveBridgeOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	if v.OutputName == nil || len(*v.OutputName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OutputName must not be empty")}
	}
	if v.OutputName != nil {
		if err := encoder.SetURI("OutputName").String(*v.OutputName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveBridgeSource struct {
}

func (*awsRestjson1_serializeOpRemoveBridgeSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveBridgeSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveBridgeSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/sources/{SourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveBridgeSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveBridgeSourceInput(v *RemoveBridgeSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	if v.SourceName == nil || len(*v.SourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceName must not be empty")}
	}
	if v.SourceName != nil {
		if err := encoder.SetURI("SourceName").String(*v.SourceName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFlowMediaStream struct {
}

func (*awsRestjson1_serializeOpRemoveFlowMediaStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFlowMediaStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFlowMediaStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/mediaStreams/{MediaStreamName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFlowMediaStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFlowMediaStreamInput(v *RemoveFlowMediaStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.MediaStreamName == nil || len(*v.MediaStreamName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MediaStreamName must not be empty")}
	}
	if v.MediaStreamName != nil {
		if err := encoder.SetURI("MediaStreamName").String(*v.MediaStreamName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFlowOutput struct {
}

func (*awsRestjson1_serializeOpRemoveFlowOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFlowOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFlowOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/outputs/{OutputArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFlowOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFlowOutputInput(v *RemoveFlowOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.OutputArn == nil || len(*v.OutputArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OutputArn must not be empty")}
	}
	if v.OutputArn != nil {
		if err := encoder.SetURI("OutputArn").String(*v.OutputArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFlowSource struct {
}

func (*awsRestjson1_serializeOpRemoveFlowSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFlowSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFlowSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source/{SourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFlowSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFlowSourceInput(v *RemoveFlowSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.SourceArn == nil || len(*v.SourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceArn must not be empty")}
	}
	if v.SourceArn != nil {
		if err := encoder.SetURI("SourceArn").String(*v.SourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRemoveFlowVpcInterface struct {
}

func (*awsRestjson1_serializeOpRemoveFlowVpcInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveFlowVpcInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveFlowVpcInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/vpcInterfaces/{VpcInterfaceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveFlowVpcInterfaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveFlowVpcInterfaceInput(v *RemoveFlowVpcInterfaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.VpcInterfaceName == nil || len(*v.VpcInterfaceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VpcInterfaceName must not be empty")}
	}
	if v.VpcInterfaceName != nil {
		if err := encoder.SetURI("VpcInterfaceName").String(*v.VpcInterfaceName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRevokeFlowEntitlement struct {
}

func (*awsRestjson1_serializeOpRevokeFlowEntitlement) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRevokeFlowEntitlement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeFlowEntitlementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/entitlements/{EntitlementArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRevokeFlowEntitlementInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRevokeFlowEntitlementInput(v *RevokeFlowEntitlementInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EntitlementArn == nil || len(*v.EntitlementArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EntitlementArn must not be empty")}
	}
	if v.EntitlementArn != nil {
		if err := encoder.SetURI("EntitlementArn").String(*v.EntitlementArn); err != nil {
			return err
		}
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartFlow struct {
}

func (*awsRestjson1_serializeOpStartFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/start/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartFlowInput(v *StartFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopFlow struct {
}

func (*awsRestjson1_serializeOpStopFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/stop/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopFlowInput(v *StopFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBridge struct {
}

func (*awsRestjson1_serializeOpUpdateBridge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBridge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBridgeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBridgeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBridgeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBridgeInput(v *UpdateBridgeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBridgeInput(v *UpdateBridgeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EgressGatewayBridge != nil {
		ok := object.Key("egressGatewayBridge")
		if err := awsRestjson1_serializeDocumentUpdateEgressGatewayBridgeRequest(v.EgressGatewayBridge, ok); err != nil {
			return err
		}
	}

	if v.IngressGatewayBridge != nil {
		ok := object.Key("ingressGatewayBridge")
		if err := awsRestjson1_serializeDocumentUpdateIngressGatewayBridgeRequest(v.IngressGatewayBridge, ok); err != nil {
			return err
		}
	}

	if v.SourceFailoverConfig != nil {
		ok := object.Key("sourceFailoverConfig")
		if err := awsRestjson1_serializeDocumentUpdateFailoverConfig(v.SourceFailoverConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBridgeOutput struct {
}

func (*awsRestjson1_serializeOpUpdateBridgeOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBridgeOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBridgeOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/outputs/{OutputName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBridgeOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBridgeOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBridgeOutputInput(v *UpdateBridgeOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	if v.OutputName == nil || len(*v.OutputName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OutputName must not be empty")}
	}
	if v.OutputName != nil {
		if err := encoder.SetURI("OutputName").String(*v.OutputName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBridgeOutputInput(v *UpdateBridgeOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkOutput != nil {
		ok := object.Key("networkOutput")
		if err := awsRestjson1_serializeDocumentUpdateBridgeNetworkOutputRequest(v.NetworkOutput, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBridgeSource struct {
}

func (*awsRestjson1_serializeOpUpdateBridgeSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBridgeSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBridgeSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/sources/{SourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBridgeSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBridgeSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBridgeSourceInput(v *UpdateBridgeSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	if v.SourceName == nil || len(*v.SourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceName must not be empty")}
	}
	if v.SourceName != nil {
		if err := encoder.SetURI("SourceName").String(*v.SourceName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBridgeSourceInput(v *UpdateBridgeSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowSource != nil {
		ok := object.Key("flowSource")
		if err := awsRestjson1_serializeDocumentUpdateBridgeFlowSourceRequest(v.FlowSource, ok); err != nil {
			return err
		}
	}

	if v.NetworkSource != nil {
		ok := object.Key("networkSource")
		if err := awsRestjson1_serializeDocumentUpdateBridgeNetworkSourceRequest(v.NetworkSource, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBridgeState struct {
}

func (*awsRestjson1_serializeOpUpdateBridgeState) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBridgeState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBridgeStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/bridges/{BridgeArn}/state")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBridgeStateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBridgeStateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBridgeStateInput(v *UpdateBridgeStateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BridgeArn == nil || len(*v.BridgeArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BridgeArn must not be empty")}
	}
	if v.BridgeArn != nil {
		if err := encoder.SetURI("BridgeArn").String(*v.BridgeArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBridgeStateInput(v *UpdateBridgeStateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DesiredState) > 0 {
		ok := object.Key("desiredState")
		ok.String(string(v.DesiredState))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlow struct {
}

func (*awsRestjson1_serializeOpUpdateFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowInput(v *UpdateFlowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowInput(v *UpdateFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Maintenance != nil {
		ok := object.Key("maintenance")
		if err := awsRestjson1_serializeDocumentUpdateMaintenance(v.Maintenance, ok); err != nil {
			return err
		}
	}

	if v.SourceFailoverConfig != nil {
		ok := object.Key("sourceFailoverConfig")
		if err := awsRestjson1_serializeDocumentUpdateFailoverConfig(v.SourceFailoverConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlowEntitlement struct {
}

func (*awsRestjson1_serializeOpUpdateFlowEntitlement) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlowEntitlement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowEntitlementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/entitlements/{EntitlementArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowEntitlementInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowEntitlementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowEntitlementInput(v *UpdateFlowEntitlementInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EntitlementArn == nil || len(*v.EntitlementArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EntitlementArn must not be empty")}
	}
	if v.EntitlementArn != nil {
		if err := encoder.SetURI("EntitlementArn").String(*v.EntitlementArn); err != nil {
			return err
		}
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowEntitlementInput(v *UpdateFlowEntitlementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentUpdateEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if len(v.EntitlementStatus) > 0 {
		ok := object.Key("entitlementStatus")
		ok.String(string(v.EntitlementStatus))
	}

	if v.Subscribers != nil {
		ok := object.Key("subscribers")
		if err := awsRestjson1_serializeDocument__listOf__string(v.Subscribers, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlowMediaStream struct {
}

func (*awsRestjson1_serializeOpUpdateFlowMediaStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlowMediaStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowMediaStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/mediaStreams/{MediaStreamName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowMediaStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowMediaStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowMediaStreamInput(v *UpdateFlowMediaStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.MediaStreamName == nil || len(*v.MediaStreamName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MediaStreamName must not be empty")}
	}
	if v.MediaStreamName != nil {
		if err := encoder.SetURI("MediaStreamName").String(*v.MediaStreamName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowMediaStreamInput(v *UpdateFlowMediaStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentMediaStreamAttributesRequest(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.ClockRate != nil {
		ok := object.Key("clockRate")
		ok.Integer(*v.ClockRate)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if len(v.MediaStreamType) > 0 {
		ok := object.Key("mediaStreamType")
		ok.String(string(v.MediaStreamType))
	}

	if v.VideoFormat != nil {
		ok := object.Key("videoFormat")
		ok.String(*v.VideoFormat)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlowOutput struct {
}

func (*awsRestjson1_serializeOpUpdateFlowOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlowOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/outputs/{OutputArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowOutputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowOutputInput(v *UpdateFlowOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.OutputArn == nil || len(*v.OutputArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member OutputArn must not be empty")}
	}
	if v.OutputArn != nil {
		if err := encoder.SetURI("OutputArn").String(*v.OutputArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowOutputInput(v *UpdateFlowOutputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrAllowList != nil {
		ok := object.Key("cidrAllowList")
		if err := awsRestjson1_serializeDocument__listOf__string(v.CidrAllowList, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentUpdateEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.MaxLatency != nil {
		ok := object.Key("maxLatency")
		ok.Integer(*v.MaxLatency)
	}

	if v.MediaStreamOutputConfigurations != nil {
		ok := object.Key("mediaStreamOutputConfigurations")
		if err := awsRestjson1_serializeDocument__listOfMediaStreamOutputConfigurationRequest(v.MediaStreamOutputConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MinLatency != nil {
		ok := object.Key("minLatency")
		ok.Integer(*v.MinLatency)
	}

	if len(v.OutputStatus) > 0 {
		ok := object.Key("outputStatus")
		ok.String(string(v.OutputStatus))
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.RemoteId != nil {
		ok := object.Key("remoteId")
		ok.String(*v.RemoteId)
	}

	if v.SenderControlPort != nil {
		ok := object.Key("senderControlPort")
		ok.Integer(*v.SenderControlPort)
	}

	if v.SenderIpAddress != nil {
		ok := object.Key("senderIpAddress")
		ok.String(*v.SenderIpAddress)
	}

	if v.SmoothingLatency != nil {
		ok := object.Key("smoothingLatency")
		ok.Integer(*v.SmoothingLatency)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	if v.VpcInterfaceAttachment != nil {
		ok := object.Key("vpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.VpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFlowSource struct {
}

func (*awsRestjson1_serializeOpUpdateFlowSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFlowSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFlowSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/flows/{FlowArn}/source/{SourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFlowSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFlowSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFlowSourceInput(v *UpdateFlowSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FlowArn == nil || len(*v.FlowArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FlowArn must not be empty")}
	}
	if v.FlowArn != nil {
		if err := encoder.SetURI("FlowArn").String(*v.FlowArn); err != nil {
			return err
		}
	}

	if v.SourceArn == nil || len(*v.SourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceArn must not be empty")}
	}
	if v.SourceArn != nil {
		if err := encoder.SetURI("SourceArn").String(*v.SourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFlowSourceInput(v *UpdateFlowSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Decryption != nil {
		ok := object.Key("decryption")
		if err := awsRestjson1_serializeDocumentUpdateEncryption(v.Decryption, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.EntitlementArn != nil {
		ok := object.Key("entitlementArn")
		ok.String(*v.EntitlementArn)
	}

	if v.GatewayBridgeSource != nil {
		ok := object.Key("gatewayBridgeSource")
		if err := awsRestjson1_serializeDocumentUpdateGatewayBridgeSourceRequest(v.GatewayBridgeSource, ok); err != nil {
			return err
		}
	}

	if v.IngestPort != nil {
		ok := object.Key("ingestPort")
		ok.Integer(*v.IngestPort)
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MaxLatency != nil {
		ok := object.Key("maxLatency")
		ok.Integer(*v.MaxLatency)
	}

	if v.MaxSyncBuffer != nil {
		ok := object.Key("maxSyncBuffer")
		ok.Integer(*v.MaxSyncBuffer)
	}

	if v.MediaStreamSourceConfigurations != nil {
		ok := object.Key("mediaStreamSourceConfigurations")
		if err := awsRestjson1_serializeDocument__listOfMediaStreamSourceConfigurationRequest(v.MediaStreamSourceConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MinLatency != nil {
		ok := object.Key("minLatency")
		ok.Integer(*v.MinLatency)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.SenderControlPort != nil {
		ok := object.Key("senderControlPort")
		ok.Integer(*v.SenderControlPort)
	}

	if v.SenderIpAddress != nil {
		ok := object.Key("senderIpAddress")
		ok.String(*v.SenderIpAddress)
	}

	if v.SourceListenerAddress != nil {
		ok := object.Key("sourceListenerAddress")
		ok.String(*v.SourceListenerAddress)
	}

	if v.SourceListenerPort != nil {
		ok := object.Key("sourceListenerPort")
		ok.Integer(*v.SourceListenerPort)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	if v.VpcInterfaceName != nil {
		ok := object.Key("vpcInterfaceName")
		ok.String(*v.VpcInterfaceName)
	}

	if v.WhitelistCidr != nil {
		ok := object.Key("whitelistCidr")
		ok.String(*v.WhitelistCidr)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGatewayInstance struct {
}

func (*awsRestjson1_serializeOpUpdateGatewayInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGatewayInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGatewayInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/gateway-instances/{GatewayInstanceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGatewayInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGatewayInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGatewayInstanceInput(v *UpdateGatewayInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GatewayInstanceArn == nil || len(*v.GatewayInstanceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GatewayInstanceArn must not be empty")}
	}
	if v.GatewayInstanceArn != nil {
		if err := encoder.SetURI("GatewayInstanceArn").String(*v.GatewayInstanceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGatewayInstanceInput(v *UpdateGatewayInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BridgePlacement) > 0 {
		ok := object.Key("bridgePlacement")
		ok.String(string(v.BridgePlacement))
	}

	return nil
}

func awsRestjson1_serializeDocument__listOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAddBridgeOutputRequest(v []types.AddBridgeOutputRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAddBridgeOutputRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAddBridgeSourceRequest(v []types.AddBridgeSourceRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAddBridgeSourceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAddMediaStreamRequest(v []types.AddMediaStreamRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAddMediaStreamRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAddOutputRequest(v []types.AddOutputRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAddOutputRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfDestinationConfigurationRequest(v []types.DestinationConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDestinationConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfGatewayNetwork(v []types.GatewayNetwork, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGatewayNetwork(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfGrantEntitlementRequest(v []types.GrantEntitlementRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGrantEntitlementRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputConfigurationRequest(v []types.InputConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfMediaStreamOutputConfigurationRequest(v []types.MediaStreamOutputConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMediaStreamOutputConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfMediaStreamSourceConfigurationRequest(v []types.MediaStreamSourceConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMediaStreamSourceConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfSetSourceRequest(v []types.SetSourceRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSetSourceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfVpcInterfaceRequest(v []types.VpcInterfaceRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVpcInterfaceRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOf__string(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAddBridgeFlowSourceRequest(v *types.AddBridgeFlowSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowArn != nil {
		ok := object.Key("flowArn")
		ok.String(*v.FlowArn)
	}

	if v.FlowVpcInterfaceAttachment != nil {
		ok := object.Key("flowVpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.FlowVpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddBridgeNetworkOutputRequest(v *types.AddBridgeNetworkOutputRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IpAddress != nil {
		ok := object.Key("ipAddress")
		ok.String(*v.IpAddress)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.Ttl != nil {
		ok := object.Key("ttl")
		ok.Integer(*v.Ttl)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddBridgeNetworkSourceRequest(v *types.AddBridgeNetworkSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MulticastIp != nil {
		ok := object.Key("multicastIp")
		ok.String(*v.MulticastIp)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}

func awsRestjson1_serializeDocumentAddBridgeOutputRequest(v *types.AddBridgeOutputRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkOutput != nil {
		ok := object.Key("networkOutput")
		if err := awsRestjson1_serializeDocumentAddBridgeNetworkOutputRequest(v.NetworkOutput, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAddBridgeSourceRequest(v *types.AddBridgeSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowSource != nil {
		ok := object.Key("flowSource")
		if err := awsRestjson1_serializeDocumentAddBridgeFlowSourceRequest(v.FlowSource, ok); err != nil {
			return err
		}
	}

	if v.NetworkSource != nil {
		ok := object.Key("networkSource")
		if err := awsRestjson1_serializeDocumentAddBridgeNetworkSourceRequest(v.NetworkSource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAddEgressGatewayBridgeRequest(v *types.AddEgressGatewayBridgeRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddIngressGatewayBridgeRequest(v *types.AddIngressGatewayBridgeRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MaxOutputs != nil {
		ok := object.Key("maxOutputs")
		ok.Integer(*v.MaxOutputs)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddMaintenance(v *types.AddMaintenance, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MaintenanceDay) > 0 {
		ok := object.Key("maintenanceDay")
		ok.String(string(v.MaintenanceDay))
	}

	if v.MaintenanceStartHour != nil {
		ok := object.Key("maintenanceStartHour")
		ok.String(*v.MaintenanceStartHour)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddMediaStreamRequest(v *types.AddMediaStreamRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentMediaStreamAttributesRequest(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.ClockRate != nil {
		ok := object.Key("clockRate")
		ok.Integer(*v.ClockRate)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.MediaStreamId != nil {
		ok := object.Key("mediaStreamId")
		ok.Integer(*v.MediaStreamId)
	}

	if v.MediaStreamName != nil {
		ok := object.Key("mediaStreamName")
		ok.String(*v.MediaStreamName)
	}

	if len(v.MediaStreamType) > 0 {
		ok := object.Key("mediaStreamType")
		ok.String(string(v.MediaStreamType))
	}

	if v.VideoFormat != nil {
		ok := object.Key("videoFormat")
		ok.String(*v.VideoFormat)
	}

	return nil
}

func awsRestjson1_serializeDocumentAddOutputRequest(v *types.AddOutputRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrAllowList != nil {
		ok := object.Key("cidrAllowList")
		if err := awsRestjson1_serializeDocument__listOf__string(v.CidrAllowList, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.MaxLatency != nil {
		ok := object.Key("maxLatency")
		ok.Integer(*v.MaxLatency)
	}

	if v.MediaStreamOutputConfigurations != nil {
		ok := object.Key("mediaStreamOutputConfigurations")
		if err := awsRestjson1_serializeDocument__listOfMediaStreamOutputConfigurationRequest(v.MediaStreamOutputConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MinLatency != nil {
		ok := object.Key("minLatency")
		ok.Integer(*v.MinLatency)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.OutputStatus) > 0 {
		ok := object.Key("outputStatus")
		ok.String(string(v.OutputStatus))
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.RemoteId != nil {
		ok := object.Key("remoteId")
		ok.String(*v.RemoteId)
	}

	if v.SenderControlPort != nil {
		ok := object.Key("senderControlPort")
		ok.Integer(*v.SenderControlPort)
	}

	if v.SmoothingLatency != nil {
		ok := object.Key("smoothingLatency")
		ok.Integer(*v.SmoothingLatency)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	if v.VpcInterfaceAttachment != nil {
		ok := object.Key("vpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.VpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationConfigurationRequest(v *types.DestinationConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationIp != nil {
		ok := object.Key("destinationIp")
		ok.String(*v.DestinationIp)
	}

	if v.DestinationPort != nil {
		ok := object.Key("destinationPort")
		ok.Integer(*v.DestinationPort)
	}

	if v.Interface != nil {
		ok := object.Key("interface")
		if err := awsRestjson1_serializeDocumentInterfaceRequest(v.Interface, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEncodingParametersRequest(v *types.EncodingParametersRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CompressionFactor != nil {
		ok := object.Key("compressionFactor")
		switch {
		case math.IsNaN(*v.CompressionFactor):
			ok.String("NaN")

		case math.IsInf(*v.CompressionFactor, 1):
			ok.String("Infinity")

		case math.IsInf(*v.CompressionFactor, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.CompressionFactor)

		}
	}

	if len(v.EncoderProfile) > 0 {
		ok := object.Key("encoderProfile")
		ok.String(string(v.EncoderProfile))
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryption(v *types.Encryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("algorithm")
		ok.String(string(v.Algorithm))
	}

	if v.ConstantInitializationVector != nil {
		ok := object.Key("constantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if v.DeviceId != nil {
		ok := object.Key("deviceId")
		ok.String(*v.DeviceId)
	}

	if len(v.KeyType) > 0 {
		ok := object.Key("keyType")
		ok.String(string(v.KeyType))
	}

	if v.Region != nil {
		ok := object.Key("region")
		ok.String(*v.Region)
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		ok.String(*v.ResourceId)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentFailoverConfig(v *types.FailoverConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FailoverMode) > 0 {
		ok := object.Key("failoverMode")
		ok.String(string(v.FailoverMode))
	}

	if v.RecoveryWindow != nil {
		ok := object.Key("recoveryWindow")
		ok.Integer(*v.RecoveryWindow)
	}

	if v.SourcePriority != nil {
		ok := object.Key("sourcePriority")
		if err := awsRestjson1_serializeDocumentSourcePriority(v.SourcePriority, ok); err != nil {
			return err
		}
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentFmtpRequest(v *types.FmtpRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelOrder != nil {
		ok := object.Key("channelOrder")
		ok.String(*v.ChannelOrder)
	}

	if len(v.Colorimetry) > 0 {
		ok := object.Key("colorimetry")
		ok.String(string(v.Colorimetry))
	}

	if v.ExactFramerate != nil {
		ok := object.Key("exactFramerate")
		ok.String(*v.ExactFramerate)
	}

	if v.Par != nil {
		ok := object.Key("par")
		ok.String(*v.Par)
	}

	if len(v.Range) > 0 {
		ok := object.Key("range")
		ok.String(string(v.Range))
	}

	if len(v.ScanMode) > 0 {
		ok := object.Key("scanMode")
		ok.String(string(v.ScanMode))
	}

	if len(v.Tcs) > 0 {
		ok := object.Key("tcs")
		ok.String(string(v.Tcs))
	}

	return nil
}

func awsRestjson1_serializeDocumentGatewayNetwork(v *types.GatewayNetwork, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CidrBlock != nil {
		ok := object.Key("cidrBlock")
		ok.String(*v.CidrBlock)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentGrantEntitlementRequest(v *types.GrantEntitlementRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataTransferSubscriberFeePercent != nil {
		ok := object.Key("dataTransferSubscriberFeePercent")
		ok.Integer(*v.DataTransferSubscriberFeePercent)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Encryption, ok); err != nil {
			return err
		}
	}

	if len(v.EntitlementStatus) > 0 {
		ok := object.Key("entitlementStatus")
		ok.String(string(v.EntitlementStatus))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Subscribers != nil {
		ok := object.Key("subscribers")
		if err := awsRestjson1_serializeDocument__listOf__string(v.Subscribers, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputConfigurationRequest(v *types.InputConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputPort != nil {
		ok := object.Key("inputPort")
		ok.Integer(*v.InputPort)
	}

	if v.Interface != nil {
		ok := object.Key("interface")
		if err := awsRestjson1_serializeDocumentInterfaceRequest(v.Interface, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInterfaceRequest(v *types.InterfaceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaStreamAttributesRequest(v *types.MediaStreamAttributesRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Fmtp != nil {
		ok := object.Key("fmtp")
		if err := awsRestjson1_serializeDocumentFmtpRequest(v.Fmtp, ok); err != nil {
			return err
		}
	}

	if v.Lang != nil {
		ok := object.Key("lang")
		ok.String(*v.Lang)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaStreamOutputConfigurationRequest(v *types.MediaStreamOutputConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationConfigurations != nil {
		ok := object.Key("destinationConfigurations")
		if err := awsRestjson1_serializeDocument__listOfDestinationConfigurationRequest(v.DestinationConfigurations, ok); err != nil {
			return err
		}
	}

	if len(v.EncodingName) > 0 {
		ok := object.Key("encodingName")
		ok.String(string(v.EncodingName))
	}

	if v.EncodingParameters != nil {
		ok := object.Key("encodingParameters")
		if err := awsRestjson1_serializeDocumentEncodingParametersRequest(v.EncodingParameters, ok); err != nil {
			return err
		}
	}

	if v.MediaStreamName != nil {
		ok := object.Key("mediaStreamName")
		ok.String(*v.MediaStreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaStreamSourceConfigurationRequest(v *types.MediaStreamSourceConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EncodingName) > 0 {
		ok := object.Key("encodingName")
		ok.String(string(v.EncodingName))
	}

	if v.InputConfigurations != nil {
		ok := object.Key("inputConfigurations")
		if err := awsRestjson1_serializeDocument__listOfInputConfigurationRequest(v.InputConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MediaStreamName != nil {
		ok := object.Key("mediaStreamName")
		ok.String(*v.MediaStreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentSetGatewayBridgeSourceRequest(v *types.SetGatewayBridgeSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BridgeArn != nil {
		ok := object.Key("bridgeArn")
		ok.String(*v.BridgeArn)
	}

	if v.VpcInterfaceAttachment != nil {
		ok := object.Key("vpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.VpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSetSourceRequest(v *types.SetSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Decryption != nil {
		ok := object.Key("decryption")
		if err := awsRestjson1_serializeDocumentEncryption(v.Decryption, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.EntitlementArn != nil {
		ok := object.Key("entitlementArn")
		ok.String(*v.EntitlementArn)
	}

	if v.GatewayBridgeSource != nil {
		ok := object.Key("gatewayBridgeSource")
		if err := awsRestjson1_serializeDocumentSetGatewayBridgeSourceRequest(v.GatewayBridgeSource, ok); err != nil {
			return err
		}
	}

	if v.IngestPort != nil {
		ok := object.Key("ingestPort")
		ok.Integer(*v.IngestPort)
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MaxLatency != nil {
		ok := object.Key("maxLatency")
		ok.Integer(*v.MaxLatency)
	}

	if v.MaxSyncBuffer != nil {
		ok := object.Key("maxSyncBuffer")
		ok.Integer(*v.MaxSyncBuffer)
	}

	if v.MediaStreamSourceConfigurations != nil {
		ok := object.Key("mediaStreamSourceConfigurations")
		if err := awsRestjson1_serializeDocument__listOfMediaStreamSourceConfigurationRequest(v.MediaStreamSourceConfigurations, ok); err != nil {
			return err
		}
	}

	if v.MinLatency != nil {
		ok := object.Key("minLatency")
		ok.Integer(*v.MinLatency)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.SenderControlPort != nil {
		ok := object.Key("senderControlPort")
		ok.Integer(*v.SenderControlPort)
	}

	if v.SenderIpAddress != nil {
		ok := object.Key("senderIpAddress")
		ok.String(*v.SenderIpAddress)
	}

	if v.SourceListenerAddress != nil {
		ok := object.Key("sourceListenerAddress")
		ok.String(*v.SourceListenerAddress)
	}

	if v.SourceListenerPort != nil {
		ok := object.Key("sourceListenerPort")
		ok.Integer(*v.SourceListenerPort)
	}

	if v.StreamId != nil {
		ok := object.Key("streamId")
		ok.String(*v.StreamId)
	}

	if v.VpcInterfaceName != nil {
		ok := object.Key("vpcInterfaceName")
		ok.String(*v.VpcInterfaceName)
	}

	if v.WhitelistCidr != nil {
		ok := object.Key("whitelistCidr")
		ok.String(*v.WhitelistCidr)
	}

	return nil
}

func awsRestjson1_serializeDocumentSourcePriority(v *types.SourcePriority, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrimarySource != nil {
		ok := object.Key("primarySource")
		ok.String(*v.PrimarySource)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBridgeFlowSourceRequest(v *types.UpdateBridgeFlowSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowArn != nil {
		ok := object.Key("flowArn")
		ok.String(*v.FlowArn)
	}

	if v.FlowVpcInterfaceAttachment != nil {
		ok := object.Key("flowVpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.FlowVpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBridgeNetworkOutputRequest(v *types.UpdateBridgeNetworkOutputRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IpAddress != nil {
		ok := object.Key("ipAddress")
		ok.String(*v.IpAddress)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	if v.Ttl != nil {
		ok := object.Key("ttl")
		ok.Integer(*v.Ttl)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBridgeNetworkSourceRequest(v *types.UpdateBridgeNetworkSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MulticastIp != nil {
		ok := object.Key("multicastIp")
		ok.String(*v.MulticastIp)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateEgressGatewayBridgeRequest(v *types.UpdateEgressGatewayBridgeRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateEncryption(v *types.UpdateEncryption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("algorithm")
		ok.String(string(v.Algorithm))
	}

	if v.ConstantInitializationVector != nil {
		ok := object.Key("constantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if v.DeviceId != nil {
		ok := object.Key("deviceId")
		ok.String(*v.DeviceId)
	}

	if len(v.KeyType) > 0 {
		ok := object.Key("keyType")
		ok.String(string(v.KeyType))
	}

	if v.Region != nil {
		ok := object.Key("region")
		ok.String(*v.Region)
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		ok.String(*v.ResourceId)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateFailoverConfig(v *types.UpdateFailoverConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FailoverMode) > 0 {
		ok := object.Key("failoverMode")
		ok.String(string(v.FailoverMode))
	}

	if v.RecoveryWindow != nil {
		ok := object.Key("recoveryWindow")
		ok.Integer(*v.RecoveryWindow)
	}

	if v.SourcePriority != nil {
		ok := object.Key("sourcePriority")
		if err := awsRestjson1_serializeDocumentSourcePriority(v.SourcePriority, ok); err != nil {
			return err
		}
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateGatewayBridgeSourceRequest(v *types.UpdateGatewayBridgeSourceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BridgeArn != nil {
		ok := object.Key("bridgeArn")
		ok.String(*v.BridgeArn)
	}

	if v.VpcInterfaceAttachment != nil {
		ok := object.Key("vpcInterfaceAttachment")
		if err := awsRestjson1_serializeDocumentVpcInterfaceAttachment(v.VpcInterfaceAttachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateIngressGatewayBridgeRequest(v *types.UpdateIngressGatewayBridgeRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MaxOutputs != nil {
		ok := object.Key("maxOutputs")
		ok.Integer(*v.MaxOutputs)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateMaintenance(v *types.UpdateMaintenance, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MaintenanceDay) > 0 {
		ok := object.Key("maintenanceDay")
		ok.String(string(v.MaintenanceDay))
	}

	if v.MaintenanceScheduledDate != nil {
		ok := object.Key("maintenanceScheduledDate")
		ok.String(*v.MaintenanceScheduledDate)
	}

	if v.MaintenanceStartHour != nil {
		ok := object.Key("maintenanceStartHour")
		ok.String(*v.MaintenanceStartHour)
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcInterfaceAttachment(v *types.VpcInterfaceAttachment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VpcInterfaceName != nil {
		ok := object.Key("vpcInterfaceName")
		ok.String(*v.VpcInterfaceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcInterfaceRequest(v *types.VpcInterfaceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.NetworkInterfaceType) > 0 {
		ok := object.Key("networkInterfaceType")
		ok.String(string(v.NetworkInterfaceType))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		ok := object.Key("subnetId")
		ok.String(*v.SubnetId)
	}

	return nil
}
