// Code generated by smithy-go-codegen DO NOT EDIT.

package rum

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rum/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the list of metrics and dimensions that a RUM app monitor is sending
// to a single destination.
func (c *Client) BatchGetRumMetricDefinitions(ctx context.Context, params *BatchGetRumMetricDefinitionsInput, optFns ...func(*Options)) (*BatchGetRumMetricDefinitionsOutput, error) {
	if params == nil {
		params = &BatchGetRumMetricDefinitionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchGetRumMetricDefinitions", params, optFns, c.addOperationBatchGetRumMetricDefinitionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchGetRumMetricDefinitionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchGetRumMetricDefinitionsInput struct {

	// The name of the CloudWatch RUM app monitor that is sending the metrics.
	//
	// This member is required.
	AppMonitorName *string

	// The type of destination that you want to view metrics for. Valid values are
	// CloudWatch and Evidently .
	//
	// This member is required.
	Destination types.MetricDestination

	// This parameter is required if Destination is Evidently . If Destination is
	// CloudWatch , do not use this parameter.
	//
	// This parameter specifies the ARN of the Evidently experiment that corresponds
	// to the destination.
	DestinationArn *string

	// The maximum number of results to return in one operation. The default is 50.
	// The maximum that you can specify is 100.
	//
	// To retrieve the remaining results, make another call with the returned NextToken
	// value.
	MaxResults *int32

	// Use the token returned by the previous operation to request the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type BatchGetRumMetricDefinitionsOutput struct {

	// An array of structures that display information about the metrics that are sent
	// by the specified app monitor to the specified destination.
	MetricDefinitions []types.MetricDefinition

	// A token that you can use in a subsequent operation to retrieve the next set of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchGetRumMetricDefinitionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchGetRumMetricDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchGetRumMetricDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchGetRumMetricDefinitions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpBatchGetRumMetricDefinitionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchGetRumMetricDefinitions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// BatchGetRumMetricDefinitionsPaginatorOptions is the paginator options for
// BatchGetRumMetricDefinitions
type BatchGetRumMetricDefinitionsPaginatorOptions struct {
	// The maximum number of results to return in one operation. The default is 50.
	// The maximum that you can specify is 100.
	//
	// To retrieve the remaining results, make another call with the returned NextToken
	// value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// BatchGetRumMetricDefinitionsPaginator is a paginator for
// BatchGetRumMetricDefinitions
type BatchGetRumMetricDefinitionsPaginator struct {
	options   BatchGetRumMetricDefinitionsPaginatorOptions
	client    BatchGetRumMetricDefinitionsAPIClient
	params    *BatchGetRumMetricDefinitionsInput
	nextToken *string
	firstPage bool
}

// NewBatchGetRumMetricDefinitionsPaginator returns a new
// BatchGetRumMetricDefinitionsPaginator
func NewBatchGetRumMetricDefinitionsPaginator(client BatchGetRumMetricDefinitionsAPIClient, params *BatchGetRumMetricDefinitionsInput, optFns ...func(*BatchGetRumMetricDefinitionsPaginatorOptions)) *BatchGetRumMetricDefinitionsPaginator {
	if params == nil {
		params = &BatchGetRumMetricDefinitionsInput{}
	}

	options := BatchGetRumMetricDefinitionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &BatchGetRumMetricDefinitionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *BatchGetRumMetricDefinitionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next BatchGetRumMetricDefinitions page.
func (p *BatchGetRumMetricDefinitionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*BatchGetRumMetricDefinitionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.BatchGetRumMetricDefinitions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// BatchGetRumMetricDefinitionsAPIClient is a client that implements the
// BatchGetRumMetricDefinitions operation.
type BatchGetRumMetricDefinitionsAPIClient interface {
	BatchGetRumMetricDefinitions(context.Context, *BatchGetRumMetricDefinitionsInput, ...func(*Options)) (*BatchGetRumMetricDefinitionsOutput, error)
}

var _ BatchGetRumMetricDefinitionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opBatchGetRumMetricDefinitions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchGetRumMetricDefinitions",
	}
}
