// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a job that optimizes a model for inference performance. To create the
// job, you provide the location of a source model, and you provide the settings
// for the optimization techniques that you want the job to apply. When the job
// completes successfully, SageMaker uploads the new optimized model to the output
// destination that you specify.
//
// For more information about how to use this action, and about the supported
// optimization techniques, see [Optimize model inference with Amazon SageMaker].
//
// [Optimize model inference with Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-optimize.html
func (c *Client) CreateOptimizationJob(ctx context.Context, params *CreateOptimizationJobInput, optFns ...func(*Options)) (*CreateOptimizationJobOutput, error) {
	if params == nil {
		params = &CreateOptimizationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateOptimizationJob", params, optFns, c.addOperationCreateOptimizationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateOptimizationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateOptimizationJobInput struct {

	// The type of instance that hosts the optimized model that you create with the
	// optimization job.
	//
	// This member is required.
	DeploymentInstanceType types.OptimizationJobDeploymentInstanceType

	// The location of the source model to optimize with an optimization job.
	//
	// This member is required.
	ModelSource *types.OptimizationJobModelSource

	// Settings for each of the optimization techniques that the job applies.
	//
	// This member is required.
	OptimizationConfigs []types.OptimizationConfig

	// A custom name for the new optimization job.
	//
	// This member is required.
	OptimizationJobName *string

	// Details for where to store the optimized model that you create with the
	// optimization job.
	//
	// This member is required.
	OutputConfig *types.OptimizationJobOutputConfig

	// The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to
	// perform tasks on your behalf.
	//
	// During model optimization, Amazon SageMaker needs your permission to:
	//
	//   - Read input data from an S3 bucket
	//
	//   - Write model artifacts to an S3 bucket
	//
	//   - Write logs to Amazon CloudWatch Logs
	//
	//   - Publish metrics to Amazon CloudWatch
	//
	// You grant permissions for all of these tasks to an IAM role. To pass this role
	// to Amazon SageMaker, the caller of this API must have the iam:PassRole
	// permission. For more information, see [Amazon SageMaker Roles.]
	//
	// [Amazon SageMaker Roles.]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html
	//
	// This member is required.
	RoleArn *string

	// Specifies a limit to how long a job can run. When the job reaches the time
	// limit, SageMaker ends the job. Use this API to cap costs.
	//
	// To stop a training job, SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts, so the results of training are not lost.
	//
	// The training algorithms provided by SageMaker automatically save the
	// intermediate results of a model training job when possible. This attempt to save
	// artifacts is only a best effort case as model might not be in a state from which
	// it can be saved. For example, if training has just started, the model might not
	// be ready to save. When saved, this intermediate data is a valid model artifact.
	// You can use it to create a model with CreateModel .
	//
	// The Neural Topic Model (NTM) currently does not support saving intermediate
	// model artifacts. When training NTMs, make sure that the maximum runtime is
	// sufficient for the training job to complete.
	//
	// This member is required.
	StoppingCondition *types.StoppingCondition

	// The environment variables to set in the model container.
	OptimizationEnvironment map[string]string

	// A list of key-value pairs associated with the optimization job. For more
	// information, see [Tagging Amazon Web Services resources]in the Amazon Web Services General Reference Guide.
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []types.Tag

	// A VPC in Amazon VPC that your optimized model has access to.
	VpcConfig *types.OptimizationVpcConfig

	noSmithyDocumentSerde
}

type CreateOptimizationJobOutput struct {

	// The Amazon Resource Name (ARN) of the optimization job.
	//
	// This member is required.
	OptimizationJobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateOptimizationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateOptimizationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateOptimizationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateOptimizationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateOptimizationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateOptimizationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateOptimizationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateOptimizationJob",
	}
}
