// Code generated by smithy-go-codegen DO NOT EDIT.

package synthetics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/synthetics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the groups that the specified canary is associated with. The
// canary that you specify must be in the current Region.
func (c *Client) ListAssociatedGroups(ctx context.Context, params *ListAssociatedGroupsInput, optFns ...func(*Options)) (*ListAssociatedGroupsOutput, error) {
	if params == nil {
		params = &ListAssociatedGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAssociatedGroups", params, optFns, c.addOperationListAssociatedGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAssociatedGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAssociatedGroupsInput struct {

	// The ARN of the canary that you want to view groups for.
	//
	// This member is required.
	ResourceArn *string

	// Specify this parameter to limit how many groups are returned each time you use
	// the ListAssociatedGroups operation. If you omit this parameter, the default of
	// 20 is used.
	MaxResults *int32

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent operation to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAssociatedGroupsOutput struct {

	// An array of structures that contain information about the groups that this
	// canary is associated with.
	Groups []types.GroupSummary

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent ListAssociatedGroups operation to retrieve the next set
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAssociatedGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAssociatedGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAssociatedGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAssociatedGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListAssociatedGroupsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAssociatedGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAssociatedGroupsPaginatorOptions is the paginator options for
// ListAssociatedGroups
type ListAssociatedGroupsPaginatorOptions struct {
	// Specify this parameter to limit how many groups are returned each time you use
	// the ListAssociatedGroups operation. If you omit this parameter, the default of
	// 20 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAssociatedGroupsPaginator is a paginator for ListAssociatedGroups
type ListAssociatedGroupsPaginator struct {
	options   ListAssociatedGroupsPaginatorOptions
	client    ListAssociatedGroupsAPIClient
	params    *ListAssociatedGroupsInput
	nextToken *string
	firstPage bool
}

// NewListAssociatedGroupsPaginator returns a new ListAssociatedGroupsPaginator
func NewListAssociatedGroupsPaginator(client ListAssociatedGroupsAPIClient, params *ListAssociatedGroupsInput, optFns ...func(*ListAssociatedGroupsPaginatorOptions)) *ListAssociatedGroupsPaginator {
	if params == nil {
		params = &ListAssociatedGroupsInput{}
	}

	options := ListAssociatedGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAssociatedGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAssociatedGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAssociatedGroups page.
func (p *ListAssociatedGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAssociatedGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAssociatedGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAssociatedGroupsAPIClient is a client that implements the
// ListAssociatedGroups operation.
type ListAssociatedGroupsAPIClient interface {
	ListAssociatedGroups(context.Context, *ListAssociatedGroupsInput, ...func(*Options)) (*ListAssociatedGroupsOutput, error)
}

var _ ListAssociatedGroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAssociatedGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAssociatedGroups",
	}
}
