# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .store_read_settings import StoreReadSettings


class FtpReadSettings(StoreReadSettings):
    """Ftp read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count
     for the source data store. Type: integer (or Expression with resultType
     integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read
     recursively. Default is true. Type: boolean (or Expression with resultType
     boolean).
    :type recursive: object
    :param wildcard_folder_path: Ftp wildcardFolderPath. Type: string (or
     Expression with resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Ftp wildcardFileName. Type: string (or
     Expression with resultType string).
    :type wildcard_file_name: object
    :param use_binary_transfer: Specify whether to use binary transfer mode
     for FTP stores.
    :type use_binary_transfer: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'use_binary_transfer': {'key': 'useBinaryTransfer', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(FtpReadSettings, self).__init__(**kwargs)
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.use_binary_transfer = kwargs.get('use_binary_transfer', None)
